/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.WorkflowInstanceCreateRequest;
import com.datadog.api.client.v2.model.WorkflowInstanceCreateResponse;
import com.datadog.api.client.v2.model.WorkflowListInstancesResponse;
import com.datadog.api.client.v2.model.WorklflowCancelInstanceResponse;
import com.datadog.api.client.v2.model.WorklflowGetInstanceResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class WorkflowAutomationApi {
    private ApiClient apiClient;

    public WorkflowAutomationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public WorkflowAutomationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WorklflowCancelInstanceResponse cancelWorkflowInstance(String workflowId, String instanceId) throws ApiException {
        return this.cancelWorkflowInstanceWithHttpInfo(workflowId, instanceId).getData();
    }

    public CompletableFuture<WorklflowCancelInstanceResponse> cancelWorkflowInstanceAsync(String workflowId, String instanceId) {
        return this.cancelWorkflowInstanceWithHttpInfoAsync(workflowId, instanceId).thenApply(response -> (WorklflowCancelInstanceResponse)response.getData());
    }

    public ApiResponse<WorklflowCancelInstanceResponse> cancelWorkflowInstanceWithHttpInfo(String workflowId, String instanceId) throws ApiException {
        Object localVarPostBody = null;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling cancelWorkflowInstance");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling cancelWorkflowInstance");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances/{instance_id}/cancel".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.cancelWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorklflowCancelInstanceResponse>(){});
    }

    public CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>> cancelWorkflowInstanceWithHttpInfoAsync(String workflowId, String instanceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling cancelWorkflowInstance"));
            return result;
        }
        if (instanceId == null) {
            CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'instanceId' when calling cancelWorkflowInstance"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances/{instance_id}/cancel".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.cancelWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowCancelInstanceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorklflowCancelInstanceResponse>(){});
    }

    public WorkflowInstanceCreateResponse createWorkflowInstance(String workflowId, WorkflowInstanceCreateRequest body) throws ApiException {
        return this.createWorkflowInstanceWithHttpInfo(workflowId, body).getData();
    }

    public CompletableFuture<WorkflowInstanceCreateResponse> createWorkflowInstanceAsync(String workflowId, WorkflowInstanceCreateRequest body) {
        return this.createWorkflowInstanceWithHttpInfoAsync(workflowId, body).thenApply(response -> (WorkflowInstanceCreateResponse)response.getData());
    }

    public ApiResponse<WorkflowInstanceCreateResponse> createWorkflowInstanceWithHttpInfo(String workflowId, WorkflowInstanceCreateRequest body) throws ApiException {
        WorkflowInstanceCreateRequest localVarPostBody = body;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling createWorkflowInstance");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWorkflowInstance");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.createWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorkflowInstanceCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>> createWorkflowInstanceWithHttpInfoAsync(String workflowId, WorkflowInstanceCreateRequest body) {
        Invocation.Builder builder;
        WorkflowInstanceCreateRequest localVarPostBody = body;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>> result = new CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling createWorkflowInstance"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>> result = new CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createWorkflowInstance"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.createWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>> result = new CompletableFuture<ApiResponse<WorkflowInstanceCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorkflowInstanceCreateResponse>(){});
    }

    public WorklflowGetInstanceResponse getWorkflowInstance(String workflowId, String instanceId) throws ApiException {
        return this.getWorkflowInstanceWithHttpInfo(workflowId, instanceId).getData();
    }

    public CompletableFuture<WorklflowGetInstanceResponse> getWorkflowInstanceAsync(String workflowId, String instanceId) {
        return this.getWorkflowInstanceWithHttpInfoAsync(workflowId, instanceId).thenApply(response -> (WorklflowGetInstanceResponse)response.getData());
    }

    public ApiResponse<WorklflowGetInstanceResponse> getWorkflowInstanceWithHttpInfo(String workflowId, String instanceId) throws ApiException {
        Object localVarPostBody = null;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling getWorkflowInstance");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling getWorkflowInstance");
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances/{instance_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.getWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorklflowGetInstanceResponse>(){});
    }

    public CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>> getWorkflowInstanceWithHttpInfoAsync(String workflowId, String instanceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling getWorkflowInstance"));
            return result;
        }
        if (instanceId == null) {
            CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'instanceId' when calling getWorkflowInstance"));
            return result;
        }
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances/{instance_id}".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.getWorkflowInstance", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>> result = new CompletableFuture<ApiResponse<WorklflowGetInstanceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorklflowGetInstanceResponse>(){});
    }

    public WorkflowListInstancesResponse listWorkflowInstances(String workflowId) throws ApiException {
        return this.listWorkflowInstancesWithHttpInfo(workflowId, new ListWorkflowInstancesOptionalParameters()).getData();
    }

    public CompletableFuture<WorkflowListInstancesResponse> listWorkflowInstancesAsync(String workflowId) {
        return this.listWorkflowInstancesWithHttpInfoAsync(workflowId, new ListWorkflowInstancesOptionalParameters()).thenApply(response -> (WorkflowListInstancesResponse)response.getData());
    }

    public WorkflowListInstancesResponse listWorkflowInstances(String workflowId, ListWorkflowInstancesOptionalParameters parameters) throws ApiException {
        return this.listWorkflowInstancesWithHttpInfo(workflowId, parameters).getData();
    }

    public CompletableFuture<WorkflowListInstancesResponse> listWorkflowInstancesAsync(String workflowId, ListWorkflowInstancesOptionalParameters parameters) {
        return this.listWorkflowInstancesWithHttpInfoAsync(workflowId, parameters).thenApply(response -> (WorkflowListInstancesResponse)response.getData());
    }

    public ApiResponse<WorkflowListInstancesResponse> listWorkflowInstancesWithHttpInfo(String workflowId, ListWorkflowInstancesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (workflowId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowId' when calling listWorkflowInstances");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.listWorkflowInstances", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorkflowListInstancesResponse>(){});
    }

    public CompletableFuture<ApiResponse<WorkflowListInstancesResponse>> listWorkflowInstancesWithHttpInfoAsync(String workflowId, ListWorkflowInstancesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (workflowId == null) {
            CompletableFuture<ApiResponse<WorkflowListInstancesResponse>> result = new CompletableFuture<ApiResponse<WorkflowListInstancesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'workflowId' when calling listWorkflowInstances"));
            return result;
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/workflows/{workflow_id}/instances".replaceAll("\\{workflow_id\\}", this.apiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v2.WorkflowAutomationApi.listWorkflowInstances", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WorkflowListInstancesResponse>> result = new CompletableFuture<ApiResponse<WorkflowListInstancesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WorkflowListInstancesResponse>(){});
    }

    public static class ListWorkflowInstancesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListWorkflowInstancesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListWorkflowInstancesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }
}

