/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLOHistoryResponseErrorWithType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"error_budget_remaining", "errors", "group", "history", "monitor_modified", "monitor_type", "name", "precision", "preview", "sli_value", "span_precision", "uptime"})
public class SLOHistorySLIData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ERROR_BUDGET_REMAINING = "error_budget_remaining";
    private Map<String, Double> errorBudgetRemaining = null;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<SLOHistoryResponseErrorWithType> errors = null;
    public static final String JSON_PROPERTY_GROUP = "group";
    private String group;
    public static final String JSON_PROPERTY_HISTORY = "history";
    private List<List<Double>> history = null;
    public static final String JSON_PROPERTY_MONITOR_MODIFIED = "monitor_modified";
    private Long monitorModified;
    public static final String JSON_PROPERTY_MONITOR_TYPE = "monitor_type";
    private String monitorType;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRECISION = "precision";
    private Map<String, Double> precision = null;
    public static final String JSON_PROPERTY_PREVIEW = "preview";
    private Boolean preview;
    public static final String JSON_PROPERTY_SLI_VALUE = "sli_value";
    private Double sliValue;
    public static final String JSON_PROPERTY_SPAN_PRECISION = "span_precision";
    private Double spanPrecision;
    public static final String JSON_PROPERTY_UPTIME = "uptime";
    private Double uptime;

    public SLOHistorySLIData errorBudgetRemaining(Map<String, Double> errorBudgetRemaining) {
        this.errorBudgetRemaining = errorBudgetRemaining;
        return this;
    }

    public SLOHistorySLIData putErrorBudgetRemainingItem(String key, Double errorBudgetRemainingItem) {
        if (this.errorBudgetRemaining == null) {
            this.errorBudgetRemaining = new HashMap<String, Double>();
        }
        this.errorBudgetRemaining.put(key, errorBudgetRemainingItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="error_budget_remaining")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getErrorBudgetRemaining() {
        return this.errorBudgetRemaining;
    }

    public void setErrorBudgetRemaining(Map<String, Double> errorBudgetRemaining) {
        this.errorBudgetRemaining = errorBudgetRemaining;
    }

    public SLOHistorySLIData errors(List<SLOHistoryResponseErrorWithType> errors) {
        this.errors = errors;
        for (SLOHistoryResponseErrorWithType item : errors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOHistorySLIData addErrorsItem(SLOHistoryResponseErrorWithType errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<SLOHistoryResponseErrorWithType>();
        }
        this.errors.add(errorsItem);
        this.unparsed |= errorsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SLOHistoryResponseErrorWithType> getErrors() {
        return this.errors;
    }

    public void setErrors(List<SLOHistoryResponseErrorWithType> errors) {
        this.errors = errors;
    }

    public SLOHistorySLIData group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public SLOHistorySLIData history(List<List<Double>> history) {
        this.history = history;
        return this;
    }

    public SLOHistorySLIData addHistoryItem(List<Double> historyItem) {
        if (this.history == null) {
            this.history = new ArrayList<List<Double>>();
        }
        this.history.add(historyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="history")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<Double>> getHistory() {
        return this.history;
    }

    public void setHistory(List<List<Double>> history) {
        this.history = history;
    }

    public SLOHistorySLIData monitorModified(Long monitorModified) {
        this.monitorModified = monitorModified;
        return this;
    }

    @Nullable
    @JsonProperty(value="monitor_modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonitorModified() {
        return this.monitorModified;
    }

    public void setMonitorModified(Long monitorModified) {
        this.monitorModified = monitorModified;
    }

    public SLOHistorySLIData monitorType(String monitorType) {
        this.monitorType = monitorType;
        return this;
    }

    @Nullable
    @JsonProperty(value="monitor_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(String monitorType) {
        this.monitorType = monitorType;
    }

    public SLOHistorySLIData name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SLOHistorySLIData precision(Map<String, Double> precision) {
        this.precision = precision;
        return this;
    }

    public SLOHistorySLIData putPrecisionItem(String key, Double precisionItem) {
        if (this.precision == null) {
            this.precision = new HashMap<String, Double>();
        }
        this.precision.put(key, precisionItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getPrecision() {
        return this.precision;
    }

    public void setPrecision(Map<String, Double> precision) {
        this.precision = precision;
    }

    public SLOHistorySLIData preview(Boolean preview) {
        this.preview = preview;
        return this;
    }

    @Nullable
    @JsonProperty(value="preview")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreview() {
        return this.preview;
    }

    public void setPreview(Boolean preview) {
        this.preview = preview;
    }

    public SLOHistorySLIData sliValue(Double sliValue) {
        this.sliValue = sliValue;
        return this;
    }

    @Nullable
    @JsonProperty(value="sli_value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSliValue() {
        return this.sliValue;
    }

    public void setSliValue(Double sliValue) {
        this.sliValue = sliValue;
    }

    public SLOHistorySLIData spanPrecision(Double spanPrecision) {
        this.spanPrecision = spanPrecision;
        return this;
    }

    @Nullable
    @JsonProperty(value="span_precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSpanPrecision() {
        return this.spanPrecision;
    }

    public void setSpanPrecision(Double spanPrecision) {
        this.spanPrecision = spanPrecision;
    }

    public SLOHistorySLIData uptime(Double uptime) {
        this.uptime = uptime;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="uptime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUptime() {
        return this.uptime;
    }

    public void setUptime(Double uptime) {
        this.uptime = uptime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistorySLIData sloHistorySliData = (SLOHistorySLIData)o;
        return Objects.equals(this.errorBudgetRemaining, sloHistorySliData.errorBudgetRemaining) && Objects.equals(this.errors, sloHistorySliData.errors) && Objects.equals(this.group, sloHistorySliData.group) && Objects.equals(this.history, sloHistorySliData.history) && Objects.equals(this.monitorModified, sloHistorySliData.monitorModified) && Objects.equals(this.monitorType, sloHistorySliData.monitorType) && Objects.equals(this.name, sloHistorySliData.name) && Objects.equals(this.precision, sloHistorySliData.precision) && Objects.equals(this.preview, sloHistorySliData.preview) && Objects.equals(this.sliValue, sloHistorySliData.sliValue) && Objects.equals(this.spanPrecision, sloHistorySliData.spanPrecision) && Objects.equals(this.uptime, sloHistorySliData.uptime);
    }

    public int hashCode() {
        return Objects.hash(this.errorBudgetRemaining, this.errors, this.group, this.history, this.monitorModified, this.monitorType, this.name, this.precision, this.preview, this.sliValue, this.spanPrecision, this.uptime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistorySLIData {\n");
        sb.append("    errorBudgetRemaining: ").append(this.toIndentedString(this.errorBudgetRemaining)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    monitorModified: ").append(this.toIndentedString(this.monitorModified)).append("\n");
        sb.append("    monitorType: ").append(this.toIndentedString(this.monitorType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    preview: ").append(this.toIndentedString(this.preview)).append("\n");
        sb.append("    sliValue: ").append(this.toIndentedString(this.sliValue)).append("\n");
        sb.append("    spanPrecision: ").append(this.toIndentedString(this.spanPrecision)).append("\n");
        sb.append("    uptime: ").append(this.toIndentedString(this.uptime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

