/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.Span;
import com.datadog.api.client.v2.model.SpansAggregateRequest;
import com.datadog.api.client.v2.model.SpansAggregateResponse;
import com.datadog.api.client.v2.model.SpansListRequest;
import com.datadog.api.client.v2.model.SpansListRequestAttributes;
import com.datadog.api.client.v2.model.SpansListRequestData;
import com.datadog.api.client.v2.model.SpansListRequestPage;
import com.datadog.api.client.v2.model.SpansListResponse;
import com.datadog.api.client.v2.model.SpansSort;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class SpansApi {
    private ApiClient apiClient;

    public SpansApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SpansApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SpansAggregateResponse aggregateSpans(SpansAggregateRequest body) throws ApiException {
        return this.aggregateSpansWithHttpInfo(body).getData();
    }

    public CompletableFuture<SpansAggregateResponse> aggregateSpansAsync(SpansAggregateRequest body) {
        return this.aggregateSpansWithHttpInfoAsync(body).thenApply(response -> (SpansAggregateResponse)response.getData());
    }

    public ApiResponse<SpansAggregateResponse> aggregateSpansWithHttpInfo(SpansAggregateRequest body) throws ApiException {
        SpansAggregateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling aggregateSpans");
        }
        String localVarPath = "/api/v2/spans/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpansApi.aggregateSpans", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansAggregateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SpansAggregateResponse>> aggregateSpansWithHttpInfoAsync(SpansAggregateRequest body) {
        Invocation.Builder builder;
        SpansAggregateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SpansAggregateResponse>> result = new CompletableFuture<ApiResponse<SpansAggregateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling aggregateSpans"));
            return result;
        }
        String localVarPath = "/api/v2/spans/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SpansApi.aggregateSpans", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SpansAggregateResponse>> result = new CompletableFuture<ApiResponse<SpansAggregateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansAggregateResponse>(){});
    }

    public SpansListResponse listSpans(SpansListRequest body) throws ApiException {
        return this.listSpansWithHttpInfo(body).getData();
    }

    public CompletableFuture<SpansListResponse> listSpansAsync(SpansListRequest body) {
        return this.listSpansWithHttpInfoAsync(body).thenApply(response -> (SpansListResponse)response.getData());
    }

    public PaginationIterable<Span> listSpansWithPagination(SpansListRequest body) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "body.getData.getAttributes.getPage.setCursor";
        Boolean valueSetterParamOptional = false;
        if (body.getData() == null) {
            body.setData(new SpansListRequestData());
        }
        if (body.getData().getAttributes() == null) {
            body.getData().setAttributes(new SpansListRequestAttributes());
        }
        if (body.getData().getAttributes().getPage() == null) {
            body.getData().getAttributes().setPage(new SpansListRequestPage());
        }
        if (body.getData().getAttributes().getPage().getLimit() == null) {
            limit = 10;
            body.getData().getAttributes().getPage().setLimit(limit);
        } else {
            limit = body.getData().getAttributes().getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("body", body);
        PaginationIterable<Span> iterator = new PaginationIterable<Span>(this, "listSpans", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<SpansListResponse> listSpansWithHttpInfo(SpansListRequest body) throws ApiException {
        SpansListRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listSpans");
        }
        String localVarPath = "/api/v2/spans/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpansApi.listSpans", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SpansListResponse>> listSpansWithHttpInfoAsync(SpansListRequest body) {
        Invocation.Builder builder;
        SpansListRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SpansListResponse>> result = new CompletableFuture<ApiResponse<SpansListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling listSpans"));
            return result;
        }
        String localVarPath = "/api/v2/spans/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SpansApi.listSpans", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SpansListResponse>> result = new CompletableFuture<ApiResponse<SpansListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansListResponse>(){});
    }

    public SpansListResponse listSpansGet() throws ApiException {
        return this.listSpansGetWithHttpInfo(new ListSpansGetOptionalParameters()).getData();
    }

    public CompletableFuture<SpansListResponse> listSpansGetAsync() {
        return this.listSpansGetWithHttpInfoAsync(new ListSpansGetOptionalParameters()).thenApply(response -> (SpansListResponse)response.getData());
    }

    public SpansListResponse listSpansGet(ListSpansGetOptionalParameters parameters) throws ApiException {
        return this.listSpansGetWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SpansListResponse> listSpansGetAsync(ListSpansGetOptionalParameters parameters) {
        return this.listSpansGetWithHttpInfoAsync(parameters).thenApply(response -> (SpansListResponse)response.getData());
    }

    public PaginationIterable<Span> listSpansGetWithPagination() {
        ListSpansGetOptionalParameters parameters = new ListSpansGetOptionalParameters();
        return this.listSpansGetWithPagination(parameters);
    }

    public PaginationIterable<Span> listSpansGetWithPagination(ListSpansGetOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 10;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<Span> iterator = new PaginationIterable<Span>(this, "listSpansGet", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<SpansListResponse> listSpansGetWithHttpInfo(ListSpansGetOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        String filterFrom = parameters.filterFrom;
        String filterTo = parameters.filterTo;
        SpansSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/spans/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpansApi.listSpansGet", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SpansListResponse>> listSpansGetWithHttpInfoAsync(ListSpansGetOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        String filterFrom = parameters.filterFrom;
        String filterTo = parameters.filterTo;
        SpansSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/spans/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.SpansApi.listSpansGet", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SpansListResponse>> result = new CompletableFuture<ApiResponse<SpansListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansListResponse>(){});
    }

    public static class ListSpansGetOptionalParameters {
        private String filterQuery;
        private String filterFrom;
        private String filterTo;
        private SpansSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListSpansGetOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListSpansGetOptionalParameters filterFrom(String filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListSpansGetOptionalParameters filterTo(String filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListSpansGetOptionalParameters sort(SpansSort sort) {
            this.sort = sort;
            return this;
        }

        public ListSpansGetOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListSpansGetOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }
}

