/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IncidentFieldAttributes;
import com.datadog.api.client.v2.model.IncidentNotificationHandle;
import com.datadog.api.client.v2.model.IncidentTimelineCellCreateAttributes;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"customer_impact_scope", "customer_impacted", "fields", "initial_cells", "notification_handles", "title"})
public class IncidentCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOMER_IMPACT_SCOPE = "customer_impact_scope";
    private String customerImpactScope;
    public static final String JSON_PROPERTY_CUSTOMER_IMPACTED = "customer_impacted";
    private Boolean customerImpacted;
    public static final String JSON_PROPERTY_FIELDS = "fields";
    private Map<String, IncidentFieldAttributes> fields = null;
    public static final String JSON_PROPERTY_INITIAL_CELLS = "initial_cells";
    private List<IncidentTimelineCellCreateAttributes> initialCells = null;
    public static final String JSON_PROPERTY_NOTIFICATION_HANDLES = "notification_handles";
    private List<IncidentNotificationHandle> notificationHandles = null;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    private Map<String, Object> additionalProperties;

    public IncidentCreateAttributes() {
    }

    @JsonCreator
    public IncidentCreateAttributes(@JsonProperty(required=true, value="customer_impacted") Boolean customerImpacted, @JsonProperty(required=true, value="title") String title) {
        this.customerImpacted = customerImpacted;
        this.title = title;
    }

    public IncidentCreateAttributes customerImpactScope(String customerImpactScope) {
        this.customerImpactScope = customerImpactScope;
        return this;
    }

    @Nullable
    @JsonProperty(value="customer_impact_scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerImpactScope() {
        return this.customerImpactScope;
    }

    public void setCustomerImpactScope(String customerImpactScope) {
        this.customerImpactScope = customerImpactScope;
    }

    public IncidentCreateAttributes customerImpacted(Boolean customerImpacted) {
        this.customerImpacted = customerImpacted;
        return this;
    }

    @JsonProperty(value="customer_impacted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCustomerImpacted() {
        return this.customerImpacted;
    }

    public void setCustomerImpacted(Boolean customerImpacted) {
        this.customerImpacted = customerImpacted;
    }

    public IncidentCreateAttributes fields(Map<String, IncidentFieldAttributes> fields) {
        this.fields = fields;
        return this;
    }

    public IncidentCreateAttributes putFieldsItem(String key, IncidentFieldAttributes fieldsItem) {
        if (this.fields == null) {
            this.fields = new HashMap<String, IncidentFieldAttributes>();
        }
        this.fields.put(key, fieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, IncidentFieldAttributes> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, IncidentFieldAttributes> fields) {
        this.fields = fields;
    }

    public IncidentCreateAttributes initialCells(List<IncidentTimelineCellCreateAttributes> initialCells) {
        this.initialCells = initialCells;
        for (IncidentTimelineCellCreateAttributes item : initialCells) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public IncidentCreateAttributes addInitialCellsItem(IncidentTimelineCellCreateAttributes initialCellsItem) {
        if (this.initialCells == null) {
            this.initialCells = new ArrayList<IncidentTimelineCellCreateAttributes>();
        }
        this.initialCells.add(initialCellsItem);
        this.unparsed |= initialCellsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="initial_cells")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncidentTimelineCellCreateAttributes> getInitialCells() {
        return this.initialCells;
    }

    public void setInitialCells(List<IncidentTimelineCellCreateAttributes> initialCells) {
        this.initialCells = initialCells;
    }

    public IncidentCreateAttributes notificationHandles(List<IncidentNotificationHandle> notificationHandles) {
        this.notificationHandles = notificationHandles;
        for (IncidentNotificationHandle item : notificationHandles) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public IncidentCreateAttributes addNotificationHandlesItem(IncidentNotificationHandle notificationHandlesItem) {
        if (this.notificationHandles == null) {
            this.notificationHandles = new ArrayList<IncidentNotificationHandle>();
        }
        this.notificationHandles.add(notificationHandlesItem);
        this.unparsed |= notificationHandlesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="notification_handles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncidentNotificationHandle> getNotificationHandles() {
        return this.notificationHandles;
    }

    public void setNotificationHandles(List<IncidentNotificationHandle> notificationHandles) {
        this.notificationHandles = notificationHandles;
    }

    public IncidentCreateAttributes title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonAnySetter
    public IncidentCreateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentCreateAttributes incidentCreateAttributes = (IncidentCreateAttributes)o;
        return Objects.equals(this.customerImpactScope, incidentCreateAttributes.customerImpactScope) && Objects.equals(this.customerImpacted, incidentCreateAttributes.customerImpacted) && Objects.equals(this.fields, incidentCreateAttributes.fields) && Objects.equals(this.initialCells, incidentCreateAttributes.initialCells) && Objects.equals(this.notificationHandles, incidentCreateAttributes.notificationHandles) && Objects.equals(this.title, incidentCreateAttributes.title) && Objects.equals(this.additionalProperties, incidentCreateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.customerImpactScope, this.customerImpacted, this.fields, this.initialCells, this.notificationHandles, this.title, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentCreateAttributes {\n");
        sb.append("    customerImpactScope: ").append(this.toIndentedString(this.customerImpactScope)).append("\n");
        sb.append("    customerImpacted: ").append(this.toIndentedString(this.customerImpacted)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    initialCells: ").append(this.toIndentedString(this.initialCells)).append("\n");
        sb.append("    notificationHandles: ").append(this.toIndentedString(this.notificationHandles)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

