/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.EventCreateRequest;
import com.datadog.api.client.v1.model.EventCreateResponse;
import com.datadog.api.client.v1.model.EventListResponse;
import com.datadog.api.client.v1.model.EventPriority;
import com.datadog.api.client.v1.model.EventResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class EventsApi {
    private ApiClient apiClient;

    public EventsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public EventsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public EventCreateResponse createEvent(EventCreateRequest body) throws ApiException {
        return this.createEventWithHttpInfo(body).getData();
    }

    public CompletableFuture<EventCreateResponse> createEventAsync(EventCreateRequest body) {
        return this.createEventWithHttpInfoAsync(body).thenApply(response -> (EventCreateResponse)response.getData());
    }

    public ApiResponse<EventCreateResponse> createEventWithHttpInfo(EventCreateRequest body) throws ApiException {
        EventCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createEvent");
        }
        String localVarPath = "/api/v1/events";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.EventsApi.createEvent", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<EventCreateResponse>> createEventWithHttpInfoAsync(EventCreateRequest body) {
        Invocation.Builder builder;
        EventCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<EventCreateResponse>> result = new CompletableFuture<ApiResponse<EventCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createEvent"));
            return result;
        }
        String localVarPath = "/api/v1/events";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("EventsApi.createEvent", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EventCreateResponse>> result = new CompletableFuture<ApiResponse<EventCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventCreateResponse>(){});
    }

    public EventResponse getEvent(Long eventId) throws ApiException {
        return this.getEventWithHttpInfo(eventId).getData();
    }

    public CompletableFuture<EventResponse> getEventAsync(Long eventId) {
        return this.getEventWithHttpInfoAsync(eventId).thenApply(response -> (EventResponse)response.getData());
    }

    public ApiResponse<EventResponse> getEventWithHttpInfo(Long eventId) throws ApiException {
        Object localVarPostBody = null;
        if (eventId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventId' when calling getEvent");
        }
        String localVarPath = "/api/v1/events/{event_id}".replaceAll("\\{event_id\\}", this.apiClient.escapeString(eventId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.EventsApi.getEvent", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventResponse>(){});
    }

    public CompletableFuture<ApiResponse<EventResponse>> getEventWithHttpInfoAsync(Long eventId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (eventId == null) {
            CompletableFuture<ApiResponse<EventResponse>> result = new CompletableFuture<ApiResponse<EventResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'eventId' when calling getEvent"));
            return result;
        }
        String localVarPath = "/api/v1/events/{event_id}".replaceAll("\\{event_id\\}", this.apiClient.escapeString(eventId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("EventsApi.getEvent", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EventResponse>> result = new CompletableFuture<ApiResponse<EventResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventResponse>(){});
    }

    public EventListResponse listEvents(Long start, Long end) throws ApiException {
        return this.listEventsWithHttpInfo(start, end, new ListEventsOptionalParameters()).getData();
    }

    public CompletableFuture<EventListResponse> listEventsAsync(Long start, Long end) {
        return this.listEventsWithHttpInfoAsync(start, end, new ListEventsOptionalParameters()).thenApply(response -> (EventListResponse)response.getData());
    }

    public EventListResponse listEvents(Long start, Long end, ListEventsOptionalParameters parameters) throws ApiException {
        return this.listEventsWithHttpInfo(start, end, parameters).getData();
    }

    public CompletableFuture<EventListResponse> listEventsAsync(Long start, Long end, ListEventsOptionalParameters parameters) {
        return this.listEventsWithHttpInfoAsync(start, end, parameters).thenApply(response -> (EventListResponse)response.getData());
    }

    public ApiResponse<EventListResponse> listEventsWithHttpInfo(Long start, Long end, ListEventsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (start == null) {
            throw new ApiException(400, "Missing the required parameter 'start' when calling listEvents");
        }
        if (end == null) {
            throw new ApiException(400, "Missing the required parameter 'end' when calling listEvents");
        }
        EventPriority priority = parameters.priority;
        String sources = parameters.sources;
        String tags = parameters.tags;
        Boolean unaggregated = parameters.unaggregated;
        Boolean excludeAggregate = parameters.excludeAggregate;
        Integer page = parameters.page;
        String localVarPath = "/api/v1/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end", end));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "priority", priority));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sources", sources));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "unaggregated", unaggregated));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "exclude_aggregate", excludeAggregate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.EventsApi.listEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventListResponse>(){});
    }

    public CompletableFuture<ApiResponse<EventListResponse>> listEventsWithHttpInfoAsync(Long start, Long end, ListEventsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (start == null) {
            CompletableFuture<ApiResponse<EventListResponse>> result = new CompletableFuture<ApiResponse<EventListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'start' when calling listEvents"));
            return result;
        }
        if (end == null) {
            CompletableFuture<ApiResponse<EventListResponse>> result = new CompletableFuture<ApiResponse<EventListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'end' when calling listEvents"));
            return result;
        }
        EventPriority priority = parameters.priority;
        String sources = parameters.sources;
        String tags = parameters.tags;
        Boolean unaggregated = parameters.unaggregated;
        Boolean excludeAggregate = parameters.excludeAggregate;
        Integer page = parameters.page;
        String localVarPath = "/api/v1/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end", end));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "priority", priority));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sources", sources));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "unaggregated", unaggregated));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "exclude_aggregate", excludeAggregate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        try {
            builder = this.apiClient.createBuilder("EventsApi.listEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EventListResponse>> result = new CompletableFuture<ApiResponse<EventListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventListResponse>(){});
    }

    public static class ListEventsOptionalParameters {
        private EventPriority priority;
        private String sources;
        private String tags;
        private Boolean unaggregated;
        private Boolean excludeAggregate;
        private Integer page;

        public ListEventsOptionalParameters priority(EventPriority priority) {
            this.priority = priority;
            return this;
        }

        public ListEventsOptionalParameters sources(String sources) {
            this.sources = sources;
            return this;
        }

        public ListEventsOptionalParameters tags(String tags) {
            this.tags = tags;
            return this;
        }

        public ListEventsOptionalParameters unaggregated(Boolean unaggregated) {
            this.unaggregated = unaggregated;
            return this;
        }

        public ListEventsOptionalParameters excludeAggregate(Boolean excludeAggregate) {
            this.excludeAggregate = excludeAggregate;
            return this;
        }

        public ListEventsOptionalParameters page(Integer page) {
            this.page = page;
            return this;
        }
    }
}

