/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.CancelDowntimesByScopeRequest;
import com.datadog.api.client.v1.model.CanceledDowntimesIds;
import com.datadog.api.client.v1.model.Downtime;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class DowntimesApi {
    private ApiClient apiClient;

    public DowntimesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DowntimesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelDowntime(Long downtimeId) throws ApiException {
        this.cancelDowntimeWithHttpInfo(downtimeId);
    }

    public CompletableFuture<Void> cancelDowntimeAsync(Long downtimeId) {
        return this.cancelDowntimeWithHttpInfoAsync(downtimeId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> cancelDowntimeWithHttpInfo(Long downtimeId) throws ApiException {
        Object localVarPostBody = null;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling cancelDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DowntimesApi.cancelDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> cancelDowntimeWithHttpInfoAsync(Long downtimeId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (downtimeId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'downtimeId' when calling cancelDowntime"));
            return result;
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DowntimesApi.cancelDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CanceledDowntimesIds cancelDowntimesByScope(CancelDowntimesByScopeRequest body) throws ApiException {
        return this.cancelDowntimesByScopeWithHttpInfo(body).getData();
    }

    public CompletableFuture<CanceledDowntimesIds> cancelDowntimesByScopeAsync(CancelDowntimesByScopeRequest body) {
        return this.cancelDowntimesByScopeWithHttpInfoAsync(body).thenApply(response -> (CanceledDowntimesIds)response.getData());
    }

    public ApiResponse<CanceledDowntimesIds> cancelDowntimesByScopeWithHttpInfo(CancelDowntimesByScopeRequest body) throws ApiException {
        CancelDowntimesByScopeRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling cancelDowntimesByScope");
        }
        String localVarPath = "/api/v1/downtime/cancel/by_scope";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DowntimesApi.cancelDowntimesByScope", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CanceledDowntimesIds>(){});
    }

    public CompletableFuture<ApiResponse<CanceledDowntimesIds>> cancelDowntimesByScopeWithHttpInfoAsync(CancelDowntimesByScopeRequest body) {
        Invocation.Builder builder;
        CancelDowntimesByScopeRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CanceledDowntimesIds>> result = new CompletableFuture<ApiResponse<CanceledDowntimesIds>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling cancelDowntimesByScope"));
            return result;
        }
        String localVarPath = "/api/v1/downtime/cancel/by_scope";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DowntimesApi.cancelDowntimesByScope", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CanceledDowntimesIds>> result = new CompletableFuture<ApiResponse<CanceledDowntimesIds>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CanceledDowntimesIds>(){});
    }

    public Downtime createDowntime(Downtime body) throws ApiException {
        return this.createDowntimeWithHttpInfo(body).getData();
    }

    public CompletableFuture<Downtime> createDowntimeAsync(Downtime body) {
        return this.createDowntimeWithHttpInfoAsync(body).thenApply(response -> (Downtime)response.getData());
    }

    public ApiResponse<Downtime> createDowntimeWithHttpInfo(Downtime body) throws ApiException {
        Downtime localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDowntime");
        }
        String localVarPath = "/api/v1/downtime";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DowntimesApi.createDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Downtime>(){});
    }

    public CompletableFuture<ApiResponse<Downtime>> createDowntimeWithHttpInfoAsync(Downtime body) {
        Invocation.Builder builder;
        Downtime localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Downtime>> result = new CompletableFuture<ApiResponse<Downtime>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDowntime"));
            return result;
        }
        String localVarPath = "/api/v1/downtime";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DowntimesApi.createDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Downtime>> result = new CompletableFuture<ApiResponse<Downtime>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Downtime>(){});
    }

    public Downtime getDowntime(Long downtimeId) throws ApiException {
        return this.getDowntimeWithHttpInfo(downtimeId).getData();
    }

    public CompletableFuture<Downtime> getDowntimeAsync(Long downtimeId) {
        return this.getDowntimeWithHttpInfoAsync(downtimeId).thenApply(response -> (Downtime)response.getData());
    }

    public ApiResponse<Downtime> getDowntimeWithHttpInfo(Long downtimeId) throws ApiException {
        Object localVarPostBody = null;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling getDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DowntimesApi.getDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Downtime>(){});
    }

    public CompletableFuture<ApiResponse<Downtime>> getDowntimeWithHttpInfoAsync(Long downtimeId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (downtimeId == null) {
            CompletableFuture<ApiResponse<Downtime>> result = new CompletableFuture<ApiResponse<Downtime>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'downtimeId' when calling getDowntime"));
            return result;
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DowntimesApi.getDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Downtime>> result = new CompletableFuture<ApiResponse<Downtime>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Downtime>(){});
    }

    public List<Downtime> listDowntimes() throws ApiException {
        return this.listDowntimesWithHttpInfo(new ListDowntimesOptionalParameters()).getData();
    }

    public CompletableFuture<List<Downtime>> listDowntimesAsync() {
        return this.listDowntimesWithHttpInfoAsync(new ListDowntimesOptionalParameters()).thenApply(response -> (List)response.getData());
    }

    public List<Downtime> listDowntimes(ListDowntimesOptionalParameters parameters) throws ApiException {
        return this.listDowntimesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<List<Downtime>> listDowntimesAsync(ListDowntimesOptionalParameters parameters) {
        return this.listDowntimesWithHttpInfoAsync(parameters).thenApply(response -> (List)response.getData());
    }

    public ApiResponse<List<Downtime>> listDowntimesWithHttpInfo(ListDowntimesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Boolean currentOnly = parameters.currentOnly;
        Boolean withCreator = parameters.withCreator;
        String localVarPath = "/api/v1/downtime";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "current_only", currentOnly));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_creator", withCreator));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DowntimesApi.listDowntimes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<Downtime>>(){});
    }

    public CompletableFuture<ApiResponse<List<Downtime>>> listDowntimesWithHttpInfoAsync(ListDowntimesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Boolean currentOnly = parameters.currentOnly;
        Boolean withCreator = parameters.withCreator;
        String localVarPath = "/api/v1/downtime";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "current_only", currentOnly));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_creator", withCreator));
        try {
            builder = this.apiClient.createBuilder("v1.DowntimesApi.listDowntimes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<Downtime>>> result = new CompletableFuture<ApiResponse<List<Downtime>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<Downtime>>(){});
    }

    public List<Downtime> listMonitorDowntimes(Long monitorId) throws ApiException {
        return this.listMonitorDowntimesWithHttpInfo(monitorId).getData();
    }

    public CompletableFuture<List<Downtime>> listMonitorDowntimesAsync(Long monitorId) {
        return this.listMonitorDowntimesWithHttpInfoAsync(monitorId).thenApply(response -> (List)response.getData());
    }

    public ApiResponse<List<Downtime>> listMonitorDowntimesWithHttpInfo(Long monitorId) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling listMonitorDowntimes");
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}/downtimes".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DowntimesApi.listMonitorDowntimes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<Downtime>>(){});
    }

    public CompletableFuture<ApiResponse<List<Downtime>>> listMonitorDowntimesWithHttpInfoAsync(Long monitorId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (monitorId == null) {
            CompletableFuture<ApiResponse<List<Downtime>>> result = new CompletableFuture<ApiResponse<List<Downtime>>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'monitorId' when calling listMonitorDowntimes"));
            return result;
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}/downtimes".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DowntimesApi.listMonitorDowntimes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<Downtime>>> result = new CompletableFuture<ApiResponse<List<Downtime>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<Downtime>>(){});
    }

    public Downtime updateDowntime(Long downtimeId, Downtime body) throws ApiException {
        return this.updateDowntimeWithHttpInfo(downtimeId, body).getData();
    }

    public CompletableFuture<Downtime> updateDowntimeAsync(Long downtimeId, Downtime body) {
        return this.updateDowntimeWithHttpInfoAsync(downtimeId, body).thenApply(response -> (Downtime)response.getData());
    }

    public ApiResponse<Downtime> updateDowntimeWithHttpInfo(Long downtimeId, Downtime body) throws ApiException {
        Downtime localVarPostBody = body;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling updateDowntime");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DowntimesApi.updateDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Downtime>(){});
    }

    public CompletableFuture<ApiResponse<Downtime>> updateDowntimeWithHttpInfoAsync(Long downtimeId, Downtime body) {
        Invocation.Builder builder;
        Downtime localVarPostBody = body;
        if (downtimeId == null) {
            CompletableFuture<ApiResponse<Downtime>> result = new CompletableFuture<ApiResponse<Downtime>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'downtimeId' when calling updateDowntime"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Downtime>> result = new CompletableFuture<ApiResponse<Downtime>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDowntime"));
            return result;
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DowntimesApi.updateDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Downtime>> result = new CompletableFuture<ApiResponse<Downtime>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Downtime>(){});
    }

    public static class ListDowntimesOptionalParameters {
        private Boolean currentOnly;
        private Boolean withCreator;

        public ListDowntimesOptionalParameters currentOnly(Boolean currentOnly) {
            this.currentOnly = currentOnly;
            return this;
        }

        public ListDowntimesOptionalParameters withCreator(Boolean withCreator) {
            this.withCreator = withCreator;
            return this;
        }
    }
}

