/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ConfluentResourceResponseAttributes;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"api_key", "resources", "tags"})
public class ConfluentAccountResponseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_KEY = "api_key";
    private String apiKey;
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private List<ConfluentResourceResponseAttributes> resources = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;

    public ConfluentAccountResponseAttributes() {
    }

    @JsonCreator
    public ConfluentAccountResponseAttributes(@JsonProperty(required=true, value="api_key") String apiKey) {
        this.apiKey = apiKey;
    }

    public ConfluentAccountResponseAttributes apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @JsonProperty(value="api_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public ConfluentAccountResponseAttributes resources(List<ConfluentResourceResponseAttributes> resources) {
        this.resources = resources;
        for (ConfluentResourceResponseAttributes item : resources) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ConfluentAccountResponseAttributes addResourcesItem(ConfluentResourceResponseAttributes resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<ConfluentResourceResponseAttributes>();
        }
        this.resources.add(resourcesItem);
        this.unparsed |= resourcesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ConfluentResourceResponseAttributes> getResources() {
        return this.resources;
    }

    public void setResources(List<ConfluentResourceResponseAttributes> resources) {
        this.resources = resources;
    }

    public ConfluentAccountResponseAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ConfluentAccountResponseAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonAnySetter
    public ConfluentAccountResponseAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfluentAccountResponseAttributes confluentAccountResponseAttributes = (ConfluentAccountResponseAttributes)o;
        return Objects.equals(this.apiKey, confluentAccountResponseAttributes.apiKey) && Objects.equals(this.resources, confluentAccountResponseAttributes.resources) && Objects.equals(this.tags, confluentAccountResponseAttributes.tags) && Objects.equals(this.additionalProperties, confluentAccountResponseAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.resources, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfluentAccountResponseAttributes {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

