/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.LogsAggregateSort;
import com.datadog.api.client.v2.model.LogsGroupByHistogram;
import com.datadog.api.client.v2.model.LogsGroupByMissing;
import com.datadog.api.client.v2.model.LogsGroupByTotal;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"facet", "histogram", "limit", "missing", "sort", "total"})
public class LogsGroupBy {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FACET = "facet";
    private String facet;
    public static final String JSON_PROPERTY_HISTOGRAM = "histogram";
    private LogsGroupByHistogram histogram;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Long limit = 10L;
    public static final String JSON_PROPERTY_MISSING = "missing";
    private LogsGroupByMissing missing;
    public static final String JSON_PROPERTY_SORT = "sort";
    private LogsAggregateSort sort;
    public static final String JSON_PROPERTY_TOTAL = "total";
    private LogsGroupByTotal total = new LogsGroupByTotal(false);
    private Map<String, Object> additionalProperties;

    public LogsGroupBy() {
    }

    @JsonCreator
    public LogsGroupBy(@JsonProperty(required=true, value="facet") String facet) {
        this.facet = facet;
    }

    public LogsGroupBy facet(String facet) {
        this.facet = facet;
        return this;
    }

    @JsonProperty(value="facet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFacet() {
        return this.facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public LogsGroupBy histogram(LogsGroupByHistogram histogram) {
        this.histogram = histogram;
        this.unparsed |= histogram.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="histogram")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsGroupByHistogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(LogsGroupByHistogram histogram) {
        this.histogram = histogram;
    }

    public LogsGroupBy limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public LogsGroupBy missing(LogsGroupByMissing missing) {
        this.missing = missing;
        this.unparsed |= missing.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="missing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsGroupByMissing getMissing() {
        return this.missing;
    }

    public void setMissing(LogsGroupByMissing missing) {
        this.missing = missing;
    }

    public LogsGroupBy sort(LogsAggregateSort sort) {
        this.sort = sort;
        this.unparsed |= sort.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsAggregateSort getSort() {
        return this.sort;
    }

    public void setSort(LogsAggregateSort sort) {
        this.sort = sort;
    }

    public LogsGroupBy total(LogsGroupByTotal total) {
        this.total = total;
        this.unparsed |= total.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsGroupByTotal getTotal() {
        return this.total;
    }

    public void setTotal(LogsGroupByTotal total) {
        this.total = total;
    }

    @JsonAnySetter
    public LogsGroupBy putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsGroupBy logsGroupBy = (LogsGroupBy)o;
        return Objects.equals(this.facet, logsGroupBy.facet) && Objects.equals(this.histogram, logsGroupBy.histogram) && Objects.equals(this.limit, logsGroupBy.limit) && Objects.equals(this.missing, logsGroupBy.missing) && Objects.equals(this.sort, logsGroupBy.sort) && Objects.equals(this.total, logsGroupBy.total) && Objects.equals(this.additionalProperties, logsGroupBy.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.facet, this.histogram, this.limit, this.missing, this.sort, this.total, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsGroupBy {\n");
        sb.append("    facet: ").append(this.toIndentedString(this.facet)).append("\n");
        sb.append("    histogram: ").append(this.toIndentedString(this.histogram)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    missing: ").append(this.toIndentedString(this.missing)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

