/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"api_key", "api_secret", "tags"})
public class ConfluentAccountUpdateRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_KEY = "api_key";
    private String apiKey;
    public static final String JSON_PROPERTY_API_SECRET = "api_secret";
    private String apiSecret;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;

    public ConfluentAccountUpdateRequestAttributes() {
    }

    @JsonCreator
    public ConfluentAccountUpdateRequestAttributes(@JsonProperty(required=true, value="api_key") String apiKey, @JsonProperty(required=true, value="api_secret") String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public ConfluentAccountUpdateRequestAttributes apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @JsonProperty(value="api_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public ConfluentAccountUpdateRequestAttributes apiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        return this;
    }

    @JsonProperty(value="api_secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiSecret() {
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public ConfluentAccountUpdateRequestAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ConfluentAccountUpdateRequestAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonAnySetter
    public ConfluentAccountUpdateRequestAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfluentAccountUpdateRequestAttributes confluentAccountUpdateRequestAttributes = (ConfluentAccountUpdateRequestAttributes)o;
        return Objects.equals(this.apiKey, confluentAccountUpdateRequestAttributes.apiKey) && Objects.equals(this.apiSecret, confluentAccountUpdateRequestAttributes.apiSecret) && Objects.equals(this.tags, confluentAccountUpdateRequestAttributes.tags) && Objects.equals(this.additionalProperties, confluentAccountUpdateRequestAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.apiSecret, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfluentAccountUpdateRequestAttributes {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    apiSecret: ").append(this.toIndentedString(this.apiSecret)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

