/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.UserTeamAttributes;
import com.datadog.api.client.v2.model.UserTeamRelationships;
import com.datadog.api.client.v2.model.UserTeamType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class UserTeamCreate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private UserTeamAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private UserTeamRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private UserTeamType type = UserTeamType.TEAM_MEMBERSHIPS;

    public UserTeamCreate() {
    }

    @JsonCreator
    public UserTeamCreate(@JsonProperty(required=true, value="type") UserTeamType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public UserTeamCreate attributes(UserTeamAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserTeamAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(UserTeamAttributes attributes) {
        this.attributes = attributes;
    }

    public UserTeamCreate relationships(UserTeamRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserTeamRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(UserTeamRelationships relationships) {
        this.relationships = relationships;
    }

    public UserTeamCreate type(UserTeamType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserTeamType getType() {
        return this.type;
    }

    public void setType(UserTeamType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTeamCreate userTeamCreate = (UserTeamCreate)o;
        return Objects.equals(this.attributes, userTeamCreate.attributes) && Objects.equals(this.relationships, userTeamCreate.relationships) && Objects.equals(this.type, userTeamCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserTeamCreate {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

