/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FastlyService;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "services"})
public class FastlyAccounResponseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<FastlyService> services = null;

    public FastlyAccounResponseAttributes() {
    }

    @JsonCreator
    public FastlyAccounResponseAttributes(@JsonProperty(required=true, value="name") String name) {
        this.name = name;
    }

    public FastlyAccounResponseAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FastlyAccounResponseAttributes services(List<FastlyService> services) {
        this.services = services;
        for (FastlyService item : services) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FastlyAccounResponseAttributes addServicesItem(FastlyService servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<FastlyService>();
        }
        this.services.add(servicesItem);
        this.unparsed |= servicesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FastlyService> getServices() {
        return this.services;
    }

    public void setServices(List<FastlyService> services) {
        this.services = services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FastlyAccounResponseAttributes fastlyAccounResponseAttributes = (FastlyAccounResponseAttributes)o;
        return Objects.equals(this.name, fastlyAccounResponseAttributes.name) && Objects.equals(this.services, fastlyAccounResponseAttributes.services);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.services);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FastlyAccounResponseAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

