/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IncidentResponseMeta;
import com.datadog.api.client.v2.model.IncidentTodoResponseData;
import com.datadog.api.client.v2.model.IncidentTodoResponseIncludedItem;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "included", "meta"})
public class IncidentTodoListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<IncidentTodoResponseData> data = new ArrayList<IncidentTodoResponseData>();
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<IncidentTodoResponseIncludedItem> included = null;
    public static final String JSON_PROPERTY_META = "meta";
    private IncidentResponseMeta meta;

    public IncidentTodoListResponse() {
    }

    @JsonCreator
    public IncidentTodoListResponse(@JsonProperty(required=true, value="data") List<IncidentTodoResponseData> data) {
        this.data = data;
    }

    public IncidentTodoListResponse data(List<IncidentTodoResponseData> data) {
        this.data = data;
        for (IncidentTodoResponseData item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public IncidentTodoListResponse addDataItem(IncidentTodoResponseData dataItem) {
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IncidentTodoResponseData> getData() {
        return this.data;
    }

    public void setData(List<IncidentTodoResponseData> data) {
        this.data = data;
    }

    @Nullable
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncidentTodoResponseIncludedItem> getIncluded() {
        return this.included;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentResponseMeta getMeta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentTodoListResponse incidentTodoListResponse = (IncidentTodoListResponse)o;
        return Objects.equals(this.data, incidentTodoListResponse.data) && Objects.equals(this.included, incidentTodoListResponse.included) && Objects.equals(this.meta, incidentTodoListResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentTodoListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

