/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=SensitiveDataScannerProductSerializer.class)
public class SensitiveDataScannerProduct {
    public static final SensitiveDataScannerProduct LOGS = new SensitiveDataScannerProduct("logs");
    public static final SensitiveDataScannerProduct RUM = new SensitiveDataScannerProduct("rum");
    public static final SensitiveDataScannerProduct EVENTS = new SensitiveDataScannerProduct("events");
    public static final SensitiveDataScannerProduct APM = new SensitiveDataScannerProduct("apm");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("logs", "rum", "events", "apm"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    SensitiveDataScannerProduct(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((SensitiveDataScannerProduct)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SensitiveDataScannerProduct fromValue(String value) {
        return new SensitiveDataScannerProduct(value);
    }

    public static class SensitiveDataScannerProductSerializer
    extends StdSerializer<SensitiveDataScannerProduct> {
        public SensitiveDataScannerProductSerializer(Class<SensitiveDataScannerProduct> t) {
            super(t);
        }

        public SensitiveDataScannerProductSerializer() {
            this(null);
        }

        public void serialize(SensitiveDataScannerProduct value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

