/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityMonitoringRuleSeverity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"condition", "name", "notifications", "status"})
public class SecurityMonitoringRuleCaseCreate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONDITION = "condition";
    private String condition;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private List<String> notifications = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SecurityMonitoringRuleSeverity status;

    public SecurityMonitoringRuleCaseCreate() {
    }

    @JsonCreator
    public SecurityMonitoringRuleCaseCreate(@JsonProperty(required=true, value="status") SecurityMonitoringRuleSeverity status) {
        this.status = status;
        this.unparsed |= !status.isValid();
    }

    public SecurityMonitoringRuleCaseCreate condition(String condition) {
        this.condition = condition;
        return this;
    }

    @Nullable
    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public SecurityMonitoringRuleCaseCreate name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleCaseCreate notifications(List<String> notifications) {
        this.notifications = notifications;
        return this;
    }

    public SecurityMonitoringRuleCaseCreate addNotificationsItem(String notificationsItem) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<String>();
        }
        this.notifications.add(notificationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="notifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<String> notifications) {
        this.notifications = notifications;
    }

    public SecurityMonitoringRuleCaseCreate status(SecurityMonitoringRuleSeverity status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityMonitoringRuleSeverity getStatus() {
        return this.status;
    }

    public void setStatus(SecurityMonitoringRuleSeverity status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleCaseCreate securityMonitoringRuleCaseCreate = (SecurityMonitoringRuleCaseCreate)o;
        return Objects.equals(this.condition, securityMonitoringRuleCaseCreate.condition) && Objects.equals(this.name, securityMonitoringRuleCaseCreate.name) && Objects.equals(this.notifications, securityMonitoringRuleCaseCreate.notifications) && Objects.equals(this.status, securityMonitoringRuleCaseCreate.status);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.name, this.notifications, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleCaseCreate {\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

