/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RUMQueryFilter;
import com.datadog.api.client.v2.model.RUMQueryOptions;
import com.datadog.api.client.v2.model.RUMQueryPageOptions;
import com.datadog.api.client.v2.model.RUMSort;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"filter", "options", "page", "sort"})
public class RUMSearchEventsRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private RUMQueryFilter filter;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private RUMQueryOptions options;
    public static final String JSON_PROPERTY_PAGE = "page";
    private RUMQueryPageOptions page;
    public static final String JSON_PROPERTY_SORT = "sort";
    private RUMSort sort;

    public RUMSearchEventsRequest filter(RUMQueryFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(RUMQueryFilter filter) {
        this.filter = filter;
    }

    public RUMSearchEventsRequest options(RUMQueryOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMQueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(RUMQueryOptions options) {
        this.options = options;
    }

    public RUMSearchEventsRequest page(RUMQueryPageOptions page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMQueryPageOptions getPage() {
        return this.page;
    }

    public void setPage(RUMQueryPageOptions page) {
        this.page = page;
    }

    public RUMSearchEventsRequest sort(RUMSort sort) {
        this.sort = sort;
        this.unparsed |= !sort.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMSort getSort() {
        return this.sort;
    }

    public void setSort(RUMSort sort) {
        if (!sort.isValid()) {
            this.unparsed = true;
        }
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RUMSearchEventsRequest rumSearchEventsRequest = (RUMSearchEventsRequest)o;
        return Objects.equals(this.filter, rumSearchEventsRequest.filter) && Objects.equals(this.options, rumSearchEventsRequest.options) && Objects.equals(this.page, rumSearchEventsRequest.page) && Objects.equals(this.sort, rumSearchEventsRequest.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.options, this.page, this.sort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RUMSearchEventsRequest {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

