/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RUMAggregationFunction;
import com.datadog.api.client.v2.model.RUMComputeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"aggregation", "interval", "metric", "type"})
public class RUMCompute {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private RUMAggregationFunction aggregation;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private String interval;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_TYPE = "type";
    private RUMComputeType type = RUMComputeType.TOTAL;

    public RUMCompute() {
    }

    @JsonCreator
    public RUMCompute(@JsonProperty(required=true, value="aggregation") RUMAggregationFunction aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
    }

    public RUMCompute aggregation(RUMAggregationFunction aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RUMAggregationFunction getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(RUMAggregationFunction aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public RUMCompute interval(String interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public RUMCompute metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public RUMCompute type(RUMComputeType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMComputeType getType() {
        return this.type;
    }

    public void setType(RUMComputeType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RUMCompute rumCompute = (RUMCompute)o;
        return Objects.equals(this.aggregation, rumCompute.aggregation) && Objects.equals(this.interval, rumCompute.interval) && Objects.equals(this.metric, rumCompute.metric) && Objects.equals(this.type, rumCompute.type);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.interval, this.metric, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RUMCompute {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

