/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.MetricCustomAggregation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"aggregations", "include_percentiles", "tags"})
public class MetricTagConfigurationUpdateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
    private List<MetricCustomAggregation> aggregations = null;
    public static final String JSON_PROPERTY_INCLUDE_PERCENTILES = "include_percentiles";
    private Boolean includePercentiles;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;

    public MetricTagConfigurationUpdateAttributes aggregations(List<MetricCustomAggregation> aggregations) {
        this.aggregations = aggregations;
        for (MetricCustomAggregation item : aggregations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MetricTagConfigurationUpdateAttributes addAggregationsItem(MetricCustomAggregation aggregationsItem) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<MetricCustomAggregation>();
        }
        this.aggregations.add(aggregationsItem);
        this.unparsed |= aggregationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MetricCustomAggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<MetricCustomAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public MetricTagConfigurationUpdateAttributes includePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
        return this;
    }

    @Nullable
    @JsonProperty(value="include_percentiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePercentiles() {
        return this.includePercentiles;
    }

    public void setIncludePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
    }

    public MetricTagConfigurationUpdateAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricTagConfigurationUpdateAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricTagConfigurationUpdateAttributes metricTagConfigurationUpdateAttributes = (MetricTagConfigurationUpdateAttributes)o;
        return Objects.equals(this.aggregations, metricTagConfigurationUpdateAttributes.aggregations) && Objects.equals(this.includePercentiles, metricTagConfigurationUpdateAttributes.includePercentiles) && Objects.equals(this.tags, metricTagConfigurationUpdateAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(this.aggregations, this.includePercentiles, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricTagConfigurationUpdateAttributes {\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    includePercentiles: ").append(this.toIndentedString(this.includePercentiles)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

