/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"from", "indexes", "query", "to"})
public class LogsQueryFilter {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FROM = "from";
    private String from = "now-15m";
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    private List<String> indexes = null;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query = "*";
    public static final String JSON_PROPERTY_TO = "to";
    private String to = "now";

    public LogsQueryFilter from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public LogsQueryFilter indexes(List<String> indexes) {
        this.indexes = indexes;
        return this;
    }

    public LogsQueryFilter addIndexesItem(String indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<String>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public LogsQueryFilter query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogsQueryFilter to(String to) {
        this.to = to;
        return this;
    }

    @Nullable
    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsQueryFilter logsQueryFilter = (LogsQueryFilter)o;
        return Objects.equals(this.from, logsQueryFilter.from) && Objects.equals(this.indexes, logsQueryFilter.indexes) && Objects.equals(this.query, logsQueryFilter.query) && Objects.equals(this.to, logsQueryFilter.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.indexes, this.query, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsQueryFilter {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

