/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.LogsAggregateSortType;
import com.datadog.api.client.v2.model.LogsAggregationFunction;
import com.datadog.api.client.v2.model.LogsSortOrder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"aggregation", "metric", "order", "type"})
public class LogsAggregateSort {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private LogsAggregationFunction aggregation;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_ORDER = "order";
    private LogsSortOrder order;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsAggregateSortType type = LogsAggregateSortType.ALPHABETICAL;

    public LogsAggregateSort aggregation(LogsAggregationFunction aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsAggregationFunction getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(LogsAggregationFunction aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public LogsAggregateSort metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public LogsAggregateSort order(LogsSortOrder order) {
        this.order = order;
        this.unparsed |= !order.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsSortOrder getOrder() {
        return this.order;
    }

    public void setOrder(LogsSortOrder order) {
        if (!order.isValid()) {
            this.unparsed = true;
        }
        this.order = order;
    }

    public LogsAggregateSort type(LogsAggregateSortType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsAggregateSortType getType() {
        return this.type;
    }

    public void setType(LogsAggregateSortType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsAggregateSort logsAggregateSort = (LogsAggregateSort)o;
        return Objects.equals(this.aggregation, logsAggregateSort.aggregation) && Objects.equals(this.metric, logsAggregateSort.metric) && Objects.equals(this.order, logsAggregateSort.order) && Objects.equals(this.type, logsAggregateSort.type);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.metric, this.order, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsAggregateSort {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

