/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.UsageAttributionBody;
import com.datadog.api.client.v1.model.UsageAttributionMetadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"metadata", "usage"})
public class UsageAttributionResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private UsageAttributionMetadata metadata;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<UsageAttributionBody> usage = null;

    public UsageAttributionResponse metadata(UsageAttributionMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageAttributionMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(UsageAttributionMetadata metadata) {
        this.metadata = metadata;
    }

    public UsageAttributionResponse usage(List<UsageAttributionBody> usage) {
        this.usage = usage;
        for (UsageAttributionBody item : usage) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UsageAttributionResponse addUsageItem(UsageAttributionBody usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<UsageAttributionBody>();
        }
        this.usage.add(usageItem);
        this.unparsed |= usageItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageAttributionBody> getUsage() {
        return this.usage;
    }

    public void setUsage(List<UsageAttributionBody> usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAttributionResponse usageAttributionResponse = (UsageAttributionResponse)o;
        return Objects.equals(this.metadata, usageAttributionResponse.metadata) && Objects.equals(this.usage, usageAttributionResponse.usage);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAttributionResponse {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

