/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.FormulaAndFunctionQueryDefinition;
import com.datadog.api.client.v1.model.FormulaAndFunctionResponseFormat;
import com.datadog.api.client.v1.model.WidgetFormula;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"formulas", "q", "queries", "response_format"})
public class TreeMapWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<WidgetFormula> formulas = null;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<FormulaAndFunctionQueryDefinition> queries = null;
    public static final String JSON_PROPERTY_RESPONSE_FORMAT = "response_format";
    private FormulaAndFunctionResponseFormat responseFormat;

    public TreeMapWidgetRequest formulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
        for (WidgetFormula item : formulas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TreeMapWidgetRequest addFormulasItem(WidgetFormula formulasItem) {
        if (this.formulas == null) {
            this.formulas = new ArrayList<WidgetFormula>();
        }
        this.formulas.add(formulasItem);
        this.unparsed |= formulasItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
    }

    public TreeMapWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public TreeMapWidgetRequest queries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
        for (FormulaAndFunctionQueryDefinition item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TreeMapWidgetRequest addQueriesItem(FormulaAndFunctionQueryDefinition queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<FormulaAndFunctionQueryDefinition>();
        }
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormulaAndFunctionQueryDefinition> getQueries() {
        return this.queries;
    }

    public void setQueries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
    }

    public TreeMapWidgetRequest responseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        this.unparsed |= !responseFormat.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormulaAndFunctionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        if (!responseFormat.isValid()) {
            this.unparsed = true;
        }
        this.responseFormat = responseFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeMapWidgetRequest treeMapWidgetRequest = (TreeMapWidgetRequest)o;
        return Objects.equals(this.formulas, treeMapWidgetRequest.formulas) && Objects.equals(this.q, treeMapWidgetRequest.q) && Objects.equals(this.queries, treeMapWidgetRequest.queries) && Objects.equals(this.responseFormat, treeMapWidgetRequest.responseFormat);
    }

    public int hashCode() {
        return Objects.hash(this.formulas, this.q, this.queries, this.responseFormat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TreeMapWidgetRequest {\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

