/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Creator;
import com.datadog.api.client.v1.model.SLOThreshold;
import com.datadog.api.client.v1.model.SLOType;
import com.datadog.api.client.v1.model.ServiceLevelObjectiveQuery;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"created_at", "creator", "description", "groups", "id", "modified_at", "monitor_ids", "monitor_tags", "name", "query", "tags", "thresholds", "type"})
public class ServiceLevelObjective {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private List<String> groups = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private Long modifiedAt;
    public static final String JSON_PROPERTY_MONITOR_IDS = "monitor_ids";
    private List<Long> monitorIds = null;
    public static final String JSON_PROPERTY_MONITOR_TAGS = "monitor_tags";
    private List<String> monitorTags = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private ServiceLevelObjectiveQuery query;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_THRESHOLDS = "thresholds";
    private List<SLOThreshold> thresholds = new ArrayList<SLOThreshold>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private SLOType type;

    public ServiceLevelObjective() {
    }

    @JsonCreator
    public ServiceLevelObjective(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="thresholds") List<SLOThreshold> thresholds, @JsonProperty(required=true, value="type") SLOType type) {
        this.name = name;
        this.thresholds = thresholds;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    public ServiceLevelObjective description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public ServiceLevelObjective groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public ServiceLevelObjective addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getModifiedAt() {
        return this.modifiedAt;
    }

    public ServiceLevelObjective monitorIds(List<Long> monitorIds) {
        this.monitorIds = monitorIds;
        return this;
    }

    public ServiceLevelObjective addMonitorIdsItem(Long monitorIdsItem) {
        if (this.monitorIds == null) {
            this.monitorIds = new ArrayList<Long>();
        }
        this.monitorIds.add(monitorIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="monitor_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getMonitorIds() {
        return this.monitorIds;
    }

    public void setMonitorIds(List<Long> monitorIds) {
        this.monitorIds = monitorIds;
    }

    public ServiceLevelObjective monitorTags(List<String> monitorTags) {
        this.monitorTags = monitorTags;
        return this;
    }

    public ServiceLevelObjective addMonitorTagsItem(String monitorTagsItem) {
        if (this.monitorTags == null) {
            this.monitorTags = new ArrayList<String>();
        }
        this.monitorTags.add(monitorTagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="monitor_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMonitorTags() {
        return this.monitorTags;
    }

    public void setMonitorTags(List<String> monitorTags) {
        this.monitorTags = monitorTags;
    }

    public ServiceLevelObjective name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceLevelObjective query(ServiceLevelObjectiveQuery query) {
        this.query = query;
        this.unparsed |= query.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceLevelObjectiveQuery getQuery() {
        return this.query;
    }

    public void setQuery(ServiceLevelObjectiveQuery query) {
        this.query = query;
    }

    public ServiceLevelObjective tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ServiceLevelObjective addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ServiceLevelObjective thresholds(List<SLOThreshold> thresholds) {
        this.thresholds = thresholds;
        for (SLOThreshold item : thresholds) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ServiceLevelObjective addThresholdsItem(SLOThreshold thresholdsItem) {
        this.thresholds.add(thresholdsItem);
        this.unparsed |= thresholdsItem.unparsed;
        return this;
    }

    @JsonProperty(value="thresholds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SLOThreshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<SLOThreshold> thresholds) {
        this.thresholds = thresholds;
    }

    public ServiceLevelObjective type(SLOType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOType getType() {
        return this.type;
    }

    public void setType(SLOType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelObjective serviceLevelObjective = (ServiceLevelObjective)o;
        return Objects.equals(this.createdAt, serviceLevelObjective.createdAt) && Objects.equals(this.creator, serviceLevelObjective.creator) && Objects.equals(this.description, serviceLevelObjective.description) && Objects.equals(this.groups, serviceLevelObjective.groups) && Objects.equals(this.id, serviceLevelObjective.id) && Objects.equals(this.modifiedAt, serviceLevelObjective.modifiedAt) && Objects.equals(this.monitorIds, serviceLevelObjective.monitorIds) && Objects.equals(this.monitorTags, serviceLevelObjective.monitorTags) && Objects.equals(this.name, serviceLevelObjective.name) && Objects.equals(this.query, serviceLevelObjective.query) && Objects.equals(this.tags, serviceLevelObjective.tags) && Objects.equals(this.thresholds, serviceLevelObjective.thresholds) && Objects.equals(this.type, serviceLevelObjective.type);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.creator, this.description, this.groups, this.id, this.modifiedAt, this.monitorIds, this.monitorTags, this.name, this.query, this.tags, this.thresholds, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelObjective {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    monitorIds: ").append(this.toIndentedString(this.monitorIds)).append("\n");
        sb.append("    monitorTags: ").append(this.toIndentedString(this.monitorTags)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    thresholds: ").append(this.toIndentedString(this.thresholds)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

