/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsURLParserType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"is_enabled", "name", "normalize_ending_slashes", "sources", "target", "type"})
public class LogsURLParser {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NORMALIZE_ENDING_SLASHES = "normalize_ending_slashes";
    private JsonNullable<Boolean> normalizeEndingSlashes = JsonNullable.of((Object)false);
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target = "http.url_details";
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsURLParserType type = LogsURLParserType.URL_PARSER;

    public LogsURLParser() {
    }

    @JsonCreator
    public LogsURLParser(@JsonProperty(required=true, value="sources") List<String> sources, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsURLParserType type) {
        this.sources = sources;
        this.target = target;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsURLParser isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsURLParser name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsURLParser normalizeEndingSlashes(Boolean normalizeEndingSlashes) {
        this.normalizeEndingSlashes = JsonNullable.of((Object)normalizeEndingSlashes);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Boolean getNormalizeEndingSlashes() {
        return (Boolean)this.normalizeEndingSlashes.orElse(null);
    }

    @JsonProperty(value="normalize_ending_slashes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getNormalizeEndingSlashes_JsonNullable() {
        return this.normalizeEndingSlashes;
    }

    @JsonProperty(value="normalize_ending_slashes")
    public void setNormalizeEndingSlashes_JsonNullable(JsonNullable<Boolean> normalizeEndingSlashes) {
        this.normalizeEndingSlashes = normalizeEndingSlashes;
    }

    public void setNormalizeEndingSlashes(Boolean normalizeEndingSlashes) {
        this.normalizeEndingSlashes = JsonNullable.of((Object)normalizeEndingSlashes);
    }

    public LogsURLParser sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsURLParser addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsURLParser target(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsURLParser type(LogsURLParserType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsURLParserType getType() {
        return this.type;
    }

    public void setType(LogsURLParserType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsURLParser logsUrlParser = (LogsURLParser)o;
        return Objects.equals(this.isEnabled, logsUrlParser.isEnabled) && Objects.equals(this.name, logsUrlParser.name) && Objects.equals(this.normalizeEndingSlashes, logsUrlParser.normalizeEndingSlashes) && Objects.equals(this.sources, logsUrlParser.sources) && Objects.equals(this.target, logsUrlParser.target) && Objects.equals(this.type, logsUrlParser.type);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.name, this.normalizeEndingSlashes, this.sources, this.target, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsURLParser {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    normalizeEndingSlashes: ").append(this.toIndentedString(this.normalizeEndingSlashes)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

