/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.SLOCorrectionCreateRequest;
import com.datadog.api.client.v1.model.SLOCorrectionListResponse;
import com.datadog.api.client.v1.model.SLOCorrectionResponse;
import com.datadog.api.client.v1.model.SLOCorrectionUpdateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class ServiceLevelObjectiveCorrectionsApi {
    private ApiClient apiClient;

    public ServiceLevelObjectiveCorrectionsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ServiceLevelObjectiveCorrectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SLOCorrectionResponse createSLOCorrection(SLOCorrectionCreateRequest body) throws ApiException {
        return this.createSLOCorrectionWithHttpInfo(body).getData();
    }

    public CompletableFuture<SLOCorrectionResponse> createSLOCorrectionAsync(SLOCorrectionCreateRequest body) {
        return this.createSLOCorrectionWithHttpInfoAsync(body).thenApply(response -> (SLOCorrectionResponse)response.getData());
    }

    public ApiResponse<SLOCorrectionResponse> createSLOCorrectionWithHttpInfo(SLOCorrectionCreateRequest body) throws ApiException {
        SLOCorrectionCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSLOCorrection");
        }
        String localVarPath = "/api/v1/slo/correction";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectiveCorrectionsApi.createSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOCorrectionResponse>> createSLOCorrectionWithHttpInfoAsync(SLOCorrectionCreateRequest body) {
        Invocation.Builder builder;
        SLOCorrectionCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SLOCorrectionResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSLOCorrection"));
            return result;
        }
        String localVarPath = "/api/v1/slo/correction";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceLevelObjectiveCorrectionsApi.createSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOCorrectionResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionResponse>(){});
    }

    public void deleteSLOCorrection(String sloCorrectionId) throws ApiException {
        this.deleteSLOCorrectionWithHttpInfo(sloCorrectionId);
    }

    public CompletableFuture<Void> deleteSLOCorrectionAsync(String sloCorrectionId) {
        return this.deleteSLOCorrectionWithHttpInfoAsync(sloCorrectionId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSLOCorrectionWithHttpInfo(String sloCorrectionId) throws ApiException {
        Object localVarPostBody = null;
        if (sloCorrectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling deleteSLOCorrection");
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectiveCorrectionsApi.deleteSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSLOCorrectionWithHttpInfoAsync(String sloCorrectionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (sloCorrectionId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling deleteSLOCorrection"));
            return result;
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceLevelObjectiveCorrectionsApi.deleteSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SLOCorrectionResponse getSLOCorrection(String sloCorrectionId) throws ApiException {
        return this.getSLOCorrectionWithHttpInfo(sloCorrectionId).getData();
    }

    public CompletableFuture<SLOCorrectionResponse> getSLOCorrectionAsync(String sloCorrectionId) {
        return this.getSLOCorrectionWithHttpInfoAsync(sloCorrectionId).thenApply(response -> (SLOCorrectionResponse)response.getData());
    }

    public ApiResponse<SLOCorrectionResponse> getSLOCorrectionWithHttpInfo(String sloCorrectionId) throws ApiException {
        Object localVarPostBody = null;
        if (sloCorrectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling getSLOCorrection");
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectiveCorrectionsApi.getSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOCorrectionResponse>> getSLOCorrectionWithHttpInfoAsync(String sloCorrectionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (sloCorrectionId == null) {
            CompletableFuture<ApiResponse<SLOCorrectionResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling getSLOCorrection"));
            return result;
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceLevelObjectiveCorrectionsApi.getSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOCorrectionResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionResponse>(){});
    }

    public SLOCorrectionListResponse listSLOCorrection() throws ApiException {
        return this.listSLOCorrectionWithHttpInfo().getData();
    }

    public CompletableFuture<SLOCorrectionListResponse> listSLOCorrectionAsync() {
        return this.listSLOCorrectionWithHttpInfoAsync().thenApply(response -> (SLOCorrectionListResponse)response.getData());
    }

    public ApiResponse<SLOCorrectionListResponse> listSLOCorrectionWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/slo/correction";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectiveCorrectionsApi.listSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOCorrectionListResponse>> listSLOCorrectionWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/slo/correction";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceLevelObjectiveCorrectionsApi.listSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOCorrectionListResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionListResponse>(){});
    }

    public SLOCorrectionResponse updateSLOCorrection(String sloCorrectionId, SLOCorrectionUpdateRequest body) throws ApiException {
        return this.updateSLOCorrectionWithHttpInfo(sloCorrectionId, body).getData();
    }

    public CompletableFuture<SLOCorrectionResponse> updateSLOCorrectionAsync(String sloCorrectionId, SLOCorrectionUpdateRequest body) {
        return this.updateSLOCorrectionWithHttpInfoAsync(sloCorrectionId, body).thenApply(response -> (SLOCorrectionResponse)response.getData());
    }

    public ApiResponse<SLOCorrectionResponse> updateSLOCorrectionWithHttpInfo(String sloCorrectionId, SLOCorrectionUpdateRequest body) throws ApiException {
        SLOCorrectionUpdateRequest localVarPostBody = body;
        if (sloCorrectionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling updateSLOCorrection");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSLOCorrection");
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectiveCorrectionsApi.updateSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOCorrectionResponse>> updateSLOCorrectionWithHttpInfoAsync(String sloCorrectionId, SLOCorrectionUpdateRequest body) {
        Invocation.Builder builder;
        SLOCorrectionUpdateRequest localVarPostBody = body;
        if (sloCorrectionId == null) {
            CompletableFuture<ApiResponse<SLOCorrectionResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'sloCorrectionId' when calling updateSLOCorrection"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SLOCorrectionResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSLOCorrection"));
            return result;
        }
        String localVarPath = "/api/v1/slo/correction/{slo_correction_id}".replaceAll("\\{slo_correction_id\\}", this.apiClient.escapeString(sloCorrectionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceLevelObjectiveCorrectionsApi.updateSLOCorrection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOCorrectionResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionResponse>(){});
    }
}

