/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.auth;

import com.datadog.api.client.ApiException;
import com.datadog.api.client.Pair;
import com.datadog.api.client.auth.Authentication;
import com.datadog.api.client.auth.OAuthFlow;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;

public class OAuth
implements Authentication {
    private static final Logger log = Logger.getLogger(OAuth.class.getName());
    private String tokenUrl;
    private String absoluteTokenUrl;
    private OAuthFlow flow = OAuthFlow.application;
    private OAuth20Service service;
    private DefaultApi20 authApi;
    private String scope;
    private String username;
    private String password;
    private String code;
    private volatile OAuth2AccessToken accessToken;

    public OAuth(String basePath, String tokenUrl) {
        this.tokenUrl = tokenUrl;
        this.absoluteTokenUrl = OAuth.createAbsoluteTokenUrl(basePath, tokenUrl);
        this.authApi = new DefaultApi20(){

            public String getAccessTokenEndpoint() {
                return OAuth.this.absoluteTokenUrl;
            }

            protected String getAuthorizationBaseUrl() {
                throw new UnsupportedOperationException("Shouldn't get there !");
            }
        };
    }

    private static String createAbsoluteTokenUrl(String basePath, String tokenUrl) {
        if (!URI.create(tokenUrl).isAbsolute()) {
            try {
                return UriBuilder.fromPath((String)basePath).path(tokenUrl).build(new Object[0]).toURL().toString();
            }
            catch (MalformedURLException e) {
                log.log(Level.SEVERE, "Couldn't create absolute token URL", e);
            }
        }
        return tokenUrl;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
        if (this.accessToken == null) {
            this.obtainAccessToken(null);
        }
        if (this.accessToken != null) {
            headerParams.put("Authorization", "Bearer " + this.accessToken.getAccessToken());
        }
    }

    public OAuth2AccessToken renewAccessToken() throws ApiException {
        String refreshToken = null;
        if (this.accessToken != null) {
            refreshToken = this.accessToken.getRefreshToken();
            this.accessToken = null;
        }
        return this.obtainAccessToken(refreshToken);
    }

    public synchronized OAuth2AccessToken obtainAccessToken(String refreshToken) throws ApiException {
        if (this.service == null) {
            log.log(Level.FINE, "service is null in obtainAccessToken.");
            return null;
        }
        try {
            if (refreshToken != null) {
                return this.service.refreshAccessToken(refreshToken);
            }
        }
        catch (OAuthException | IOException | InterruptedException | ExecutionException e) {
            log.log(Level.FINE, "Refreshing the access token using the refresh token failed", e);
        }
        try {
            switch (this.flow) {
                case password: {
                    if (this.username != null && this.password != null) {
                        this.accessToken = this.service.getAccessTokenPasswordGrant(this.username, this.password, this.scope);
                    }
                    break;
                }
                case accessCode: {
                    if (this.code != null) {
                        this.accessToken = this.service.getAccessToken(this.code);
                        this.code = null;
                    }
                    break;
                }
                case application: {
                    this.accessToken = this.service.getAccessTokenClientCredentialsGrant(this.scope);
                    break;
                }
                default: {
                    log.log(Level.SEVERE, "Invalid flow in obtainAccessToken: " + (Object)((Object)this.flow));
                    break;
                }
            }
        }
        catch (OAuthException | IOException | InterruptedException | ExecutionException e) {
            throw new ApiException(e);
        }
        return this.accessToken;
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public OAuth setAccessToken(OAuth2AccessToken accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public OAuth setAccessToken(String accessToken) {
        this.accessToken = new OAuth2AccessToken(accessToken);
        return this;
    }

    public OAuth setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public OAuth setCredentials(String clientId, String clientSecret, Boolean debug) {
        this.service = Boolean.TRUE.equals(debug) ? new ServiceBuilder(clientId).apiSecret(clientSecret).debug().build(this.authApi) : new ServiceBuilder(clientId).apiSecret(clientSecret).build(this.authApi);
        return this;
    }

    public OAuth usePasswordFlow(String username, String password) {
        this.flow = OAuthFlow.password;
        this.username = username;
        this.password = password;
        return this;
    }

    public OAuth useAuthorizationCodeFlow(String code) {
        this.flow = OAuthFlow.accessCode;
        this.code = code;
        return this;
    }

    public OAuth setFlow(OAuthFlow flow) {
        this.flow = flow;
        return this;
    }

    public void setBasePath(String basePath) {
        this.absoluteTokenUrl = OAuth.createAbsoluteTokenUrl(basePath, this.tokenUrl);
    }
}

