/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.TableWidgetCellDisplayMode;
import com.datadog.api.v1.client.model.WidgetConditionalFormat;
import com.datadog.api.v1.client.model.WidgetFormulaLimit;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"alias", "cell_display_mode", "conditional_formats", "formula", "limit"})
public class WidgetFormula {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias;
    public static final String JSON_PROPERTY_CELL_DISPLAY_MODE = "cell_display_mode";
    private TableWidgetCellDisplayMode cellDisplayMode;
    public static final String JSON_PROPERTY_CONDITIONAL_FORMATS = "conditional_formats";
    private List<WidgetConditionalFormat> conditionalFormats = null;
    public static final String JSON_PROPERTY_FORMULA = "formula";
    private String formula;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private WidgetFormulaLimit limit;

    public WidgetFormula() {
    }

    @JsonCreator
    public WidgetFormula(@JsonProperty(required=true, value="formula") String formula) {
        this.formula = formula;
    }

    public WidgetFormula alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public WidgetFormula cellDisplayMode(TableWidgetCellDisplayMode cellDisplayMode) {
        this.cellDisplayMode = cellDisplayMode;
        this.unparsed |= !cellDisplayMode.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="cell_display_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableWidgetCellDisplayMode getCellDisplayMode() {
        return this.cellDisplayMode;
    }

    public void setCellDisplayMode(TableWidgetCellDisplayMode cellDisplayMode) {
        if (!cellDisplayMode.isValid()) {
            this.unparsed = true;
        }
        this.cellDisplayMode = cellDisplayMode;
    }

    public WidgetFormula conditionalFormats(List<WidgetConditionalFormat> conditionalFormats) {
        this.conditionalFormats = conditionalFormats;
        for (WidgetConditionalFormat item : conditionalFormats) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public WidgetFormula addConditionalFormatsItem(WidgetConditionalFormat conditionalFormatsItem) {
        if (this.conditionalFormats == null) {
            this.conditionalFormats = new ArrayList<WidgetConditionalFormat>();
        }
        this.conditionalFormats.add(conditionalFormatsItem);
        this.unparsed |= conditionalFormatsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="conditional_formats")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetConditionalFormat> getConditionalFormats() {
        return this.conditionalFormats;
    }

    public void setConditionalFormats(List<WidgetConditionalFormat> conditionalFormats) {
        this.conditionalFormats = conditionalFormats;
    }

    public WidgetFormula formula(String formula) {
        this.formula = formula;
        return this;
    }

    @JsonProperty(value="formula")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public WidgetFormula limit(WidgetFormulaLimit limit) {
        this.limit = limit;
        this.unparsed |= limit.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetFormulaLimit getLimit() {
        return this.limit;
    }

    public void setLimit(WidgetFormulaLimit limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetFormula widgetFormula = (WidgetFormula)o;
        return Objects.equals(this.alias, widgetFormula.alias) && Objects.equals(this.cellDisplayMode, widgetFormula.cellDisplayMode) && Objects.equals(this.conditionalFormats, widgetFormula.conditionalFormats) && Objects.equals(this.formula, widgetFormula.formula) && Objects.equals(this.limit, widgetFormula.limit);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.cellDisplayMode, this.conditionalFormats, this.formula, this.limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetFormula {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    cellDisplayMode: ").append(this.toIndentedString(this.cellDisplayMode)).append("\n");
        sb.append("    conditionalFormats: ").append(this.toIndentedString(this.conditionalFormats)).append("\n");
        sb.append("    formula: ").append(this.toIndentedString(this.formula)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

