/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=TimeseriesBackgroundTypeSerializer.class)
public class TimeseriesBackgroundType {
    public static final TimeseriesBackgroundType BARS = new TimeseriesBackgroundType("bars");
    public static final TimeseriesBackgroundType AREA = new TimeseriesBackgroundType("area");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("bars", "area"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    TimeseriesBackgroundType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((TimeseriesBackgroundType)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TimeseriesBackgroundType fromValue(String value) {
        return new TimeseriesBackgroundType(value);
    }

    public static class TimeseriesBackgroundTypeSerializer
    extends StdSerializer<TimeseriesBackgroundType> {
        public TimeseriesBackgroundTypeSerializer(Class<TimeseriesBackgroundType> t) {
            super(t);
        }

        public TimeseriesBackgroundTypeSerializer() {
            this(null);
        }

        public void serialize(TimeseriesBackgroundType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

