/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FunnelQuery;
import com.datadog.api.v1.client.model.FunnelRequestType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

@JsonPropertyOrder(value={"query", "request_type"})
public class FunnelWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_QUERY = "query";
    private FunnelQuery query;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "request_type";
    private FunnelRequestType requestType;

    public FunnelWidgetRequest() {
    }

    @JsonCreator
    public FunnelWidgetRequest(@JsonProperty(required=true, value="query") FunnelQuery query, @JsonProperty(required=true, value="request_type") FunnelRequestType requestType) {
        this.query = query;
        this.unparsed |= query.unparsed;
        this.requestType = requestType;
        this.unparsed |= !requestType.isValid();
    }

    public FunnelWidgetRequest query(FunnelQuery query) {
        this.query = query;
        this.unparsed |= query.unparsed;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FunnelQuery getQuery() {
        return this.query;
    }

    public void setQuery(FunnelQuery query) {
        this.query = query;
    }

    public FunnelWidgetRequest requestType(FunnelRequestType requestType) {
        this.requestType = requestType;
        this.unparsed |= !requestType.isValid();
        return this;
    }

    @JsonProperty(value="request_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FunnelRequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(FunnelRequestType requestType) {
        if (!requestType.isValid()) {
            this.unparsed = true;
        }
        this.requestType = requestType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunnelWidgetRequest funnelWidgetRequest = (FunnelWidgetRequest)o;
        return Objects.equals(this.query, funnelWidgetRequest.query) && Objects.equals(this.requestType, funnelWidgetRequest.requestType);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.requestType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunnelWidgetRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString(this.requestType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

