/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.SyntheticsAPITest;
import com.datadog.api.v1.client.model.SyntheticsAPITestResultFull;
import com.datadog.api.v1.client.model.SyntheticsBatchDetails;
import com.datadog.api.v1.client.model.SyntheticsBrowserTest;
import com.datadog.api.v1.client.model.SyntheticsBrowserTestResultFull;
import com.datadog.api.v1.client.model.SyntheticsCITestBody;
import com.datadog.api.v1.client.model.SyntheticsDeleteTestsPayload;
import com.datadog.api.v1.client.model.SyntheticsDeleteTestsResponse;
import com.datadog.api.v1.client.model.SyntheticsGetAPITestLatestResultsResponse;
import com.datadog.api.v1.client.model.SyntheticsGetBrowserTestLatestResultsResponse;
import com.datadog.api.v1.client.model.SyntheticsGlobalVariable;
import com.datadog.api.v1.client.model.SyntheticsListGlobalVariablesResponse;
import com.datadog.api.v1.client.model.SyntheticsListTestsResponse;
import com.datadog.api.v1.client.model.SyntheticsLocations;
import com.datadog.api.v1.client.model.SyntheticsPrivateLocation;
import com.datadog.api.v1.client.model.SyntheticsPrivateLocationCreationResponse;
import com.datadog.api.v1.client.model.SyntheticsTestDetails;
import com.datadog.api.v1.client.model.SyntheticsTriggerBody;
import com.datadog.api.v1.client.model.SyntheticsTriggerCITestsResponse;
import com.datadog.api.v1.client.model.SyntheticsUpdateTestPauseStatusPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class SyntheticsApi {
    private ApiClient apiClient;

    public SyntheticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SyntheticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SyntheticsGlobalVariable createGlobalVariable(SyntheticsGlobalVariable body) throws ApiException {
        return this.createGlobalVariableWithHttpInfo(body).getData();
    }

    public CompletableFuture<SyntheticsGlobalVariable> createGlobalVariableAsync(SyntheticsGlobalVariable body) {
        return this.createGlobalVariableWithHttpInfoAsync(body).thenApply(response -> (SyntheticsGlobalVariable)response.getData());
    }

    public ApiResponse<SyntheticsGlobalVariable> createGlobalVariableWithHttpInfo(SyntheticsGlobalVariable body) throws ApiException {
        SyntheticsGlobalVariable localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.createGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGlobalVariable>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> createGlobalVariableWithHttpInfoAsync(SyntheticsGlobalVariable body) {
        Invocation.Builder builder;
        SyntheticsGlobalVariable localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> result = new CompletableFuture<ApiResponse<SyntheticsGlobalVariable>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createGlobalVariable"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/variables";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.createGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> result = new CompletableFuture<ApiResponse<SyntheticsGlobalVariable>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGlobalVariable>(){});
    }

    public SyntheticsPrivateLocationCreationResponse createPrivateLocation(SyntheticsPrivateLocation body) throws ApiException {
        return this.createPrivateLocationWithHttpInfo(body).getData();
    }

    public CompletableFuture<SyntheticsPrivateLocationCreationResponse> createPrivateLocationAsync(SyntheticsPrivateLocation body) {
        return this.createPrivateLocationWithHttpInfoAsync(body).thenApply(response -> (SyntheticsPrivateLocationCreationResponse)response.getData());
    }

    public ApiResponse<SyntheticsPrivateLocationCreationResponse> createPrivateLocationWithHttpInfo(SyntheticsPrivateLocation body) throws ApiException {
        SyntheticsPrivateLocation localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.createPrivateLocation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsPrivateLocationCreationResponse>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsPrivateLocationCreationResponse>> createPrivateLocationWithHttpInfoAsync(SyntheticsPrivateLocation body) {
        Invocation.Builder builder;
        SyntheticsPrivateLocation localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsPrivateLocationCreationResponse>> result = new CompletableFuture<ApiResponse<SyntheticsPrivateLocationCreationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createPrivateLocation"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/private-locations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.createPrivateLocation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsPrivateLocationCreationResponse>> result = new CompletableFuture<ApiResponse<SyntheticsPrivateLocationCreationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsPrivateLocationCreationResponse>(){});
    }

    public SyntheticsAPITest createSyntheticsAPITest(SyntheticsAPITest body) throws ApiException {
        return this.createSyntheticsAPITestWithHttpInfo(body).getData();
    }

    public CompletableFuture<SyntheticsAPITest> createSyntheticsAPITestAsync(SyntheticsAPITest body) {
        return this.createSyntheticsAPITestWithHttpInfoAsync(body).thenApply(response -> (SyntheticsAPITest)response.getData());
    }

    public ApiResponse<SyntheticsAPITest> createSyntheticsAPITestWithHttpInfo(SyntheticsAPITest body) throws ApiException {
        SyntheticsAPITest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSyntheticsAPITest");
        }
        String localVarPath = "/api/v1/synthetics/tests/api";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.createSyntheticsAPITest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsAPITest>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsAPITest>> createSyntheticsAPITestWithHttpInfoAsync(SyntheticsAPITest body) {
        Invocation.Builder builder;
        SyntheticsAPITest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsAPITest>> result = new CompletableFuture<ApiResponse<SyntheticsAPITest>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSyntheticsAPITest"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/api";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.createSyntheticsAPITest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsAPITest>> result = new CompletableFuture<ApiResponse<SyntheticsAPITest>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsAPITest>(){});
    }

    public SyntheticsBrowserTest createSyntheticsBrowserTest(SyntheticsBrowserTest body) throws ApiException {
        return this.createSyntheticsBrowserTestWithHttpInfo(body).getData();
    }

    public CompletableFuture<SyntheticsBrowserTest> createSyntheticsBrowserTestAsync(SyntheticsBrowserTest body) {
        return this.createSyntheticsBrowserTestWithHttpInfoAsync(body).thenApply(response -> (SyntheticsBrowserTest)response.getData());
    }

    public ApiResponse<SyntheticsBrowserTest> createSyntheticsBrowserTestWithHttpInfo(SyntheticsBrowserTest body) throws ApiException {
        SyntheticsBrowserTest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSyntheticsBrowserTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.createSyntheticsBrowserTest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBrowserTest>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsBrowserTest>> createSyntheticsBrowserTestWithHttpInfoAsync(SyntheticsBrowserTest body) {
        Invocation.Builder builder;
        SyntheticsBrowserTest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTest>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTest>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSyntheticsBrowserTest"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/browser";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.createSyntheticsBrowserTest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTest>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTest>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBrowserTest>(){});
    }

    public void deleteGlobalVariable(String variableId) throws ApiException {
        this.deleteGlobalVariableWithHttpInfo(variableId);
    }

    public CompletableFuture<Void> deleteGlobalVariableAsync(String variableId) {
        return this.deleteGlobalVariableWithHttpInfoAsync(variableId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteGlobalVariableWithHttpInfo(String variableId) throws ApiException {
        Object localVarPostBody = null;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling deleteGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.deleteGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteGlobalVariableWithHttpInfoAsync(String variableId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (variableId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'variableId' when calling deleteGlobalVariable"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.deleteGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deletePrivateLocation(String locationId) throws ApiException {
        this.deletePrivateLocationWithHttpInfo(locationId);
    }

    public CompletableFuture<Void> deletePrivateLocationAsync(String locationId) {
        return this.deletePrivateLocationWithHttpInfoAsync(locationId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deletePrivateLocationWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deletePrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.deletePrivateLocation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deletePrivateLocationWithHttpInfoAsync(String locationId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (locationId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'locationId' when calling deletePrivateLocation"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.deletePrivateLocation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SyntheticsDeleteTestsResponse deleteTests(SyntheticsDeleteTestsPayload body) throws ApiException {
        return this.deleteTestsWithHttpInfo(body).getData();
    }

    public CompletableFuture<SyntheticsDeleteTestsResponse> deleteTestsAsync(SyntheticsDeleteTestsPayload body) {
        return this.deleteTestsWithHttpInfoAsync(body).thenApply(response -> (SyntheticsDeleteTestsResponse)response.getData());
    }

    public ApiResponse<SyntheticsDeleteTestsResponse> deleteTestsWithHttpInfo(SyntheticsDeleteTestsPayload body) throws ApiException {
        SyntheticsDeleteTestsPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteTests");
        }
        String localVarPath = "/api/v1/synthetics/tests/delete";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.deleteTests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsDeleteTestsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsDeleteTestsResponse>> deleteTestsWithHttpInfoAsync(SyntheticsDeleteTestsPayload body) {
        Invocation.Builder builder;
        SyntheticsDeleteTestsPayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsDeleteTestsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsDeleteTestsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteTests"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/delete";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.deleteTests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsDeleteTestsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsDeleteTestsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsDeleteTestsResponse>(){});
    }

    public SyntheticsGlobalVariable editGlobalVariable(String variableId, SyntheticsGlobalVariable body) throws ApiException {
        return this.editGlobalVariableWithHttpInfo(variableId, body).getData();
    }

    public CompletableFuture<SyntheticsGlobalVariable> editGlobalVariableAsync(String variableId, SyntheticsGlobalVariable body) {
        return this.editGlobalVariableWithHttpInfoAsync(variableId, body).thenApply(response -> (SyntheticsGlobalVariable)response.getData());
    }

    public ApiResponse<SyntheticsGlobalVariable> editGlobalVariableWithHttpInfo(String variableId, SyntheticsGlobalVariable body) throws ApiException {
        SyntheticsGlobalVariable localVarPostBody = body;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling editGlobalVariable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.editGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGlobalVariable>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> editGlobalVariableWithHttpInfoAsync(String variableId, SyntheticsGlobalVariable body) {
        Invocation.Builder builder;
        SyntheticsGlobalVariable localVarPostBody = body;
        if (variableId == null) {
            CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> result = new CompletableFuture<ApiResponse<SyntheticsGlobalVariable>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'variableId' when calling editGlobalVariable"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> result = new CompletableFuture<ApiResponse<SyntheticsGlobalVariable>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editGlobalVariable"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.editGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> result = new CompletableFuture<ApiResponse<SyntheticsGlobalVariable>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGlobalVariable>(){});
    }

    public SyntheticsAPITest getAPITest(String publicId) throws ApiException {
        return this.getAPITestWithHttpInfo(publicId).getData();
    }

    public CompletableFuture<SyntheticsAPITest> getAPITestAsync(String publicId) {
        return this.getAPITestWithHttpInfoAsync(publicId).thenApply(response -> (SyntheticsAPITest)response.getData());
    }

    public ApiResponse<SyntheticsAPITest> getAPITestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITest");
        }
        String localVarPath = "/api/v1/synthetics/tests/api/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getAPITest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsAPITest>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsAPITest>> getAPITestWithHttpInfoAsync(String publicId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsAPITest>> result = new CompletableFuture<ApiResponse<SyntheticsAPITest>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITest"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/api/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getAPITest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsAPITest>> result = new CompletableFuture<ApiResponse<SyntheticsAPITest>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsAPITest>(){});
    }

    public SyntheticsGetAPITestLatestResultsResponse getAPITestLatestResults(String publicId) throws ApiException {
        return this.getAPITestLatestResultsWithHttpInfo(publicId, new GetAPITestLatestResultsOptionalParameters()).getData();
    }

    public CompletableFuture<SyntheticsGetAPITestLatestResultsResponse> getAPITestLatestResultsAsync(String publicId) {
        return this.getAPITestLatestResultsWithHttpInfoAsync(publicId, new GetAPITestLatestResultsOptionalParameters()).thenApply(response -> (SyntheticsGetAPITestLatestResultsResponse)response.getData());
    }

    public SyntheticsGetAPITestLatestResultsResponse getAPITestLatestResults(String publicId, GetAPITestLatestResultsOptionalParameters parameters) throws ApiException {
        return this.getAPITestLatestResultsWithHttpInfo(publicId, parameters).getData();
    }

    public CompletableFuture<SyntheticsGetAPITestLatestResultsResponse> getAPITestLatestResultsAsync(String publicId, GetAPITestLatestResultsOptionalParameters parameters) {
        return this.getAPITestLatestResultsWithHttpInfoAsync(publicId, parameters).thenApply(response -> (SyntheticsGetAPITestLatestResultsResponse)response.getData());
    }

    public ApiResponse<SyntheticsGetAPITestLatestResultsResponse> getAPITestLatestResultsWithHttpInfo(String publicId, GetAPITestLatestResultsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestLatestResults");
        }
        Long fromTs = parameters.fromTs;
        Long toTs = parameters.toTs;
        List probeDc = parameters.probeDc;
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getAPITestLatestResults", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGetAPITestLatestResultsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsGetAPITestLatestResultsResponse>> getAPITestLatestResultsWithHttpInfoAsync(String publicId, GetAPITestLatestResultsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsGetAPITestLatestResultsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsGetAPITestLatestResultsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestLatestResults"));
            return result;
        }
        Long fromTs = parameters.fromTs;
        Long toTs = parameters.toTs;
        List probeDc = parameters.probeDc;
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getAPITestLatestResults", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsGetAPITestLatestResultsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsGetAPITestLatestResultsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGetAPITestLatestResultsResponse>(){});
    }

    public SyntheticsAPITestResultFull getAPITestResult(String publicId, String resultId) throws ApiException {
        return this.getAPITestResultWithHttpInfo(publicId, resultId).getData();
    }

    public CompletableFuture<SyntheticsAPITestResultFull> getAPITestResultAsync(String publicId, String resultId) {
        return this.getAPITestResultWithHttpInfoAsync(publicId, resultId).thenApply(response -> (SyntheticsAPITestResultFull)response.getData());
    }

    public ApiResponse<SyntheticsAPITestResultFull> getAPITestResultWithHttpInfo(String publicId, String resultId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestResult");
        }
        if (resultId == null) {
            throw new ApiException(400, "Missing the required parameter 'resultId' when calling getAPITestResult");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getAPITestResult", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsAPITestResultFull>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsAPITestResultFull>> getAPITestResultWithHttpInfoAsync(String publicId, String resultId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsAPITestResultFull>> result = new CompletableFuture<ApiResponse<SyntheticsAPITestResultFull>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestResult"));
            return result;
        }
        if (resultId == null) {
            CompletableFuture<ApiResponse<SyntheticsAPITestResultFull>> result = new CompletableFuture<ApiResponse<SyntheticsAPITestResultFull>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'resultId' when calling getAPITestResult"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getAPITestResult", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsAPITestResultFull>> result = new CompletableFuture<ApiResponse<SyntheticsAPITestResultFull>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsAPITestResultFull>(){});
    }

    public SyntheticsBrowserTest getBrowserTest(String publicId) throws ApiException {
        return this.getBrowserTestWithHttpInfo(publicId).getData();
    }

    public CompletableFuture<SyntheticsBrowserTest> getBrowserTestAsync(String publicId) {
        return this.getBrowserTestWithHttpInfoAsync(publicId).thenApply(response -> (SyntheticsBrowserTest)response.getData());
    }

    public ApiResponse<SyntheticsBrowserTest> getBrowserTestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getBrowserTest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBrowserTest>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsBrowserTest>> getBrowserTestWithHttpInfoAsync(String publicId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTest>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTest>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTest"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getBrowserTest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTest>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTest>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBrowserTest>(){});
    }

    public SyntheticsGetBrowserTestLatestResultsResponse getBrowserTestLatestResults(String publicId) throws ApiException {
        return this.getBrowserTestLatestResultsWithHttpInfo(publicId, new GetBrowserTestLatestResultsOptionalParameters()).getData();
    }

    public CompletableFuture<SyntheticsGetBrowserTestLatestResultsResponse> getBrowserTestLatestResultsAsync(String publicId) {
        return this.getBrowserTestLatestResultsWithHttpInfoAsync(publicId, new GetBrowserTestLatestResultsOptionalParameters()).thenApply(response -> (SyntheticsGetBrowserTestLatestResultsResponse)response.getData());
    }

    public SyntheticsGetBrowserTestLatestResultsResponse getBrowserTestLatestResults(String publicId, GetBrowserTestLatestResultsOptionalParameters parameters) throws ApiException {
        return this.getBrowserTestLatestResultsWithHttpInfo(publicId, parameters).getData();
    }

    public CompletableFuture<SyntheticsGetBrowserTestLatestResultsResponse> getBrowserTestLatestResultsAsync(String publicId, GetBrowserTestLatestResultsOptionalParameters parameters) {
        return this.getBrowserTestLatestResultsWithHttpInfoAsync(publicId, parameters).thenApply(response -> (SyntheticsGetBrowserTestLatestResultsResponse)response.getData());
    }

    public ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse> getBrowserTestLatestResultsWithHttpInfo(String publicId, GetBrowserTestLatestResultsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestLatestResults");
        }
        Long fromTs = parameters.fromTs;
        Long toTs = parameters.toTs;
        List probeDc = parameters.probeDc;
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getBrowserTestLatestResults", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGetBrowserTestLatestResultsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse>> getBrowserTestLatestResultsWithHttpInfoAsync(String publicId, GetBrowserTestLatestResultsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestLatestResults"));
            return result;
        }
        Long fromTs = parameters.fromTs;
        Long toTs = parameters.toTs;
        List probeDc = parameters.probeDc;
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getBrowserTestLatestResults", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGetBrowserTestLatestResultsResponse>(){});
    }

    public SyntheticsBrowserTestResultFull getBrowserTestResult(String publicId, String resultId) throws ApiException {
        return this.getBrowserTestResultWithHttpInfo(publicId, resultId).getData();
    }

    public CompletableFuture<SyntheticsBrowserTestResultFull> getBrowserTestResultAsync(String publicId, String resultId) {
        return this.getBrowserTestResultWithHttpInfoAsync(publicId, resultId).thenApply(response -> (SyntheticsBrowserTestResultFull)response.getData());
    }

    public ApiResponse<SyntheticsBrowserTestResultFull> getBrowserTestResultWithHttpInfo(String publicId, String resultId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestResult");
        }
        if (resultId == null) {
            throw new ApiException(400, "Missing the required parameter 'resultId' when calling getBrowserTestResult");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getBrowserTestResult", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBrowserTestResultFull>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsBrowserTestResultFull>> getBrowserTestResultWithHttpInfoAsync(String publicId, String resultId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTestResultFull>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTestResultFull>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestResult"));
            return result;
        }
        if (resultId == null) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTestResultFull>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTestResultFull>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'resultId' when calling getBrowserTestResult"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getBrowserTestResult", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTestResultFull>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTestResultFull>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBrowserTestResultFull>(){});
    }

    public SyntheticsGlobalVariable getGlobalVariable(String variableId) throws ApiException {
        return this.getGlobalVariableWithHttpInfo(variableId).getData();
    }

    public CompletableFuture<SyntheticsGlobalVariable> getGlobalVariableAsync(String variableId) {
        return this.getGlobalVariableWithHttpInfoAsync(variableId).thenApply(response -> (SyntheticsGlobalVariable)response.getData());
    }

    public ApiResponse<SyntheticsGlobalVariable> getGlobalVariableWithHttpInfo(String variableId) throws ApiException {
        Object localVarPostBody = null;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling getGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGlobalVariable>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> getGlobalVariableWithHttpInfoAsync(String variableId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (variableId == null) {
            CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> result = new CompletableFuture<ApiResponse<SyntheticsGlobalVariable>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'variableId' when calling getGlobalVariable"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsGlobalVariable>> result = new CompletableFuture<ApiResponse<SyntheticsGlobalVariable>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsGlobalVariable>(){});
    }

    public SyntheticsPrivateLocation getPrivateLocation(String locationId) throws ApiException {
        return this.getPrivateLocationWithHttpInfo(locationId).getData();
    }

    public CompletableFuture<SyntheticsPrivateLocation> getPrivateLocationAsync(String locationId) {
        return this.getPrivateLocationWithHttpInfoAsync(locationId).thenApply(response -> (SyntheticsPrivateLocation)response.getData());
    }

    public ApiResponse<SyntheticsPrivateLocation> getPrivateLocationWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling getPrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getPrivateLocation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsPrivateLocation>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsPrivateLocation>> getPrivateLocationWithHttpInfoAsync(String locationId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (locationId == null) {
            CompletableFuture<ApiResponse<SyntheticsPrivateLocation>> result = new CompletableFuture<ApiResponse<SyntheticsPrivateLocation>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'locationId' when calling getPrivateLocation"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getPrivateLocation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsPrivateLocation>> result = new CompletableFuture<ApiResponse<SyntheticsPrivateLocation>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsPrivateLocation>(){});
    }

    public SyntheticsBatchDetails getSyntheticsCIBatch(String batchId) throws ApiException {
        return this.getSyntheticsCIBatchWithHttpInfo(batchId).getData();
    }

    public CompletableFuture<SyntheticsBatchDetails> getSyntheticsCIBatchAsync(String batchId) {
        return this.getSyntheticsCIBatchWithHttpInfoAsync(batchId).thenApply(response -> (SyntheticsBatchDetails)response.getData());
    }

    public ApiResponse<SyntheticsBatchDetails> getSyntheticsCIBatchWithHttpInfo(String batchId) throws ApiException {
        Object localVarPostBody = null;
        if (batchId == null) {
            throw new ApiException(400, "Missing the required parameter 'batchId' when calling getSyntheticsCIBatch");
        }
        String localVarPath = "/api/v1/synthetics/ci/batch/{batch_id}".replaceAll("\\{batch_id\\}", this.apiClient.escapeString(batchId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getSyntheticsCIBatch", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBatchDetails>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsBatchDetails>> getSyntheticsCIBatchWithHttpInfoAsync(String batchId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (batchId == null) {
            CompletableFuture<ApiResponse<SyntheticsBatchDetails>> result = new CompletableFuture<ApiResponse<SyntheticsBatchDetails>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'batchId' when calling getSyntheticsCIBatch"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/ci/batch/{batch_id}".replaceAll("\\{batch_id\\}", this.apiClient.escapeString(batchId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getSyntheticsCIBatch", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsBatchDetails>> result = new CompletableFuture<ApiResponse<SyntheticsBatchDetails>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBatchDetails>(){});
    }

    public SyntheticsTestDetails getTest(String publicId) throws ApiException {
        return this.getTestWithHttpInfo(publicId).getData();
    }

    public CompletableFuture<SyntheticsTestDetails> getTestAsync(String publicId) {
        return this.getTestWithHttpInfoAsync(publicId).thenApply(response -> (SyntheticsTestDetails)response.getData());
    }

    public ApiResponse<SyntheticsTestDetails> getTestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.getTest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsTestDetails>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsTestDetails>> getTestWithHttpInfoAsync(String publicId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsTestDetails>> result = new CompletableFuture<ApiResponse<SyntheticsTestDetails>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling getTest"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.getTest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsTestDetails>> result = new CompletableFuture<ApiResponse<SyntheticsTestDetails>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsTestDetails>(){});
    }

    public SyntheticsListGlobalVariablesResponse listGlobalVariables() throws ApiException {
        return this.listGlobalVariablesWithHttpInfo().getData();
    }

    public CompletableFuture<SyntheticsListGlobalVariablesResponse> listGlobalVariablesAsync() {
        return this.listGlobalVariablesWithHttpInfoAsync().thenApply(response -> (SyntheticsListGlobalVariablesResponse)response.getData());
    }

    public ApiResponse<SyntheticsListGlobalVariablesResponse> listGlobalVariablesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/variables";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.listGlobalVariables", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsListGlobalVariablesResponse>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsListGlobalVariablesResponse>> listGlobalVariablesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/variables";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.listGlobalVariables", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsListGlobalVariablesResponse>> result = new CompletableFuture<ApiResponse<SyntheticsListGlobalVariablesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsListGlobalVariablesResponse>(){});
    }

    public SyntheticsLocations listLocations() throws ApiException {
        return this.listLocationsWithHttpInfo().getData();
    }

    public CompletableFuture<SyntheticsLocations> listLocationsAsync() {
        return this.listLocationsWithHttpInfoAsync().thenApply(response -> (SyntheticsLocations)response.getData());
    }

    public ApiResponse<SyntheticsLocations> listLocationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/locations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.listLocations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsLocations>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsLocations>> listLocationsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/locations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.listLocations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsLocations>> result = new CompletableFuture<ApiResponse<SyntheticsLocations>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsLocations>(){});
    }

    public SyntheticsListTestsResponse listTests() throws ApiException {
        return this.listTestsWithHttpInfo().getData();
    }

    public CompletableFuture<SyntheticsListTestsResponse> listTestsAsync() {
        return this.listTestsWithHttpInfoAsync().thenApply(response -> (SyntheticsListTestsResponse)response.getData());
    }

    public ApiResponse<SyntheticsListTestsResponse> listTestsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/tests";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.listTests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsListTestsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsListTestsResponse>> listTestsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/tests";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.listTests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsListTestsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsListTestsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsListTestsResponse>(){});
    }

    public SyntheticsTriggerCITestsResponse triggerCITests(SyntheticsCITestBody body) throws ApiException {
        return this.triggerCITestsWithHttpInfo(body).getData();
    }

    public CompletableFuture<SyntheticsTriggerCITestsResponse> triggerCITestsAsync(SyntheticsCITestBody body) {
        return this.triggerCITestsWithHttpInfoAsync(body).thenApply(response -> (SyntheticsTriggerCITestsResponse)response.getData());
    }

    public ApiResponse<SyntheticsTriggerCITestsResponse> triggerCITestsWithHttpInfo(SyntheticsCITestBody body) throws ApiException {
        SyntheticsCITestBody localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling triggerCITests");
        }
        String localVarPath = "/api/v1/synthetics/tests/trigger/ci";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.triggerCITests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsTriggerCITestsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>> triggerCITestsWithHttpInfoAsync(SyntheticsCITestBody body) {
        Invocation.Builder builder;
        SyntheticsCITestBody localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling triggerCITests"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/trigger/ci";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.triggerCITests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsTriggerCITestsResponse>(){});
    }

    public SyntheticsTriggerCITestsResponse triggerTests(SyntheticsTriggerBody body) throws ApiException {
        return this.triggerTestsWithHttpInfo(body).getData();
    }

    public CompletableFuture<SyntheticsTriggerCITestsResponse> triggerTestsAsync(SyntheticsTriggerBody body) {
        return this.triggerTestsWithHttpInfoAsync(body).thenApply(response -> (SyntheticsTriggerCITestsResponse)response.getData());
    }

    public ApiResponse<SyntheticsTriggerCITestsResponse> triggerTestsWithHttpInfo(SyntheticsTriggerBody body) throws ApiException {
        SyntheticsTriggerBody localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling triggerTests");
        }
        String localVarPath = "/api/v1/synthetics/tests/trigger";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.triggerTests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsTriggerCITestsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>> triggerTestsWithHttpInfoAsync(SyntheticsTriggerBody body) {
        Invocation.Builder builder;
        SyntheticsTriggerBody localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling triggerTests"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/trigger";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.triggerTests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>> result = new CompletableFuture<ApiResponse<SyntheticsTriggerCITestsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsTriggerCITestsResponse>(){});
    }

    public SyntheticsAPITest updateAPITest(String publicId, SyntheticsAPITest body) throws ApiException {
        return this.updateAPITestWithHttpInfo(publicId, body).getData();
    }

    public CompletableFuture<SyntheticsAPITest> updateAPITestAsync(String publicId, SyntheticsAPITest body) {
        return this.updateAPITestWithHttpInfoAsync(publicId, body).thenApply(response -> (SyntheticsAPITest)response.getData());
    }

    public ApiResponse<SyntheticsAPITest> updateAPITestWithHttpInfo(String publicId, SyntheticsAPITest body) throws ApiException {
        SyntheticsAPITest localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateAPITest");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAPITest");
        }
        String localVarPath = "/api/v1/synthetics/tests/api/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.updateAPITest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsAPITest>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsAPITest>> updateAPITestWithHttpInfoAsync(String publicId, SyntheticsAPITest body) {
        Invocation.Builder builder;
        SyntheticsAPITest localVarPostBody = body;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsAPITest>> result = new CompletableFuture<ApiResponse<SyntheticsAPITest>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling updateAPITest"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsAPITest>> result = new CompletableFuture<ApiResponse<SyntheticsAPITest>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAPITest"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/api/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.updateAPITest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsAPITest>> result = new CompletableFuture<ApiResponse<SyntheticsAPITest>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsAPITest>(){});
    }

    public SyntheticsBrowserTest updateBrowserTest(String publicId, SyntheticsBrowserTest body) throws ApiException {
        return this.updateBrowserTestWithHttpInfo(publicId, body).getData();
    }

    public CompletableFuture<SyntheticsBrowserTest> updateBrowserTestAsync(String publicId, SyntheticsBrowserTest body) {
        return this.updateBrowserTestWithHttpInfoAsync(publicId, body).thenApply(response -> (SyntheticsBrowserTest)response.getData());
    }

    public ApiResponse<SyntheticsBrowserTest> updateBrowserTestWithHttpInfo(String publicId, SyntheticsBrowserTest body) throws ApiException {
        SyntheticsBrowserTest localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateBrowserTest");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateBrowserTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.updateBrowserTest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBrowserTest>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsBrowserTest>> updateBrowserTestWithHttpInfoAsync(String publicId, SyntheticsBrowserTest body) {
        Invocation.Builder builder;
        SyntheticsBrowserTest localVarPostBody = body;
        if (publicId == null) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTest>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTest>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling updateBrowserTest"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTest>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTest>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateBrowserTest"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.updateBrowserTest", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsBrowserTest>> result = new CompletableFuture<ApiResponse<SyntheticsBrowserTest>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsBrowserTest>(){});
    }

    public SyntheticsPrivateLocation updatePrivateLocation(String locationId, SyntheticsPrivateLocation body) throws ApiException {
        return this.updatePrivateLocationWithHttpInfo(locationId, body).getData();
    }

    public CompletableFuture<SyntheticsPrivateLocation> updatePrivateLocationAsync(String locationId, SyntheticsPrivateLocation body) {
        return this.updatePrivateLocationWithHttpInfoAsync(locationId, body).thenApply(response -> (SyntheticsPrivateLocation)response.getData());
    }

    public ApiResponse<SyntheticsPrivateLocation> updatePrivateLocationWithHttpInfo(String locationId, SyntheticsPrivateLocation body) throws ApiException {
        SyntheticsPrivateLocation localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updatePrivateLocation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.updatePrivateLocation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsPrivateLocation>(){});
    }

    public CompletableFuture<ApiResponse<SyntheticsPrivateLocation>> updatePrivateLocationWithHttpInfoAsync(String locationId, SyntheticsPrivateLocation body) {
        Invocation.Builder builder;
        SyntheticsPrivateLocation localVarPostBody = body;
        if (locationId == null) {
            CompletableFuture<ApiResponse<SyntheticsPrivateLocation>> result = new CompletableFuture<ApiResponse<SyntheticsPrivateLocation>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'locationId' when calling updatePrivateLocation"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SyntheticsPrivateLocation>> result = new CompletableFuture<ApiResponse<SyntheticsPrivateLocation>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updatePrivateLocation"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.updatePrivateLocation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SyntheticsPrivateLocation>> result = new CompletableFuture<ApiResponse<SyntheticsPrivateLocation>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SyntheticsPrivateLocation>(){});
    }

    public Boolean updateTestPauseStatus(String publicId, SyntheticsUpdateTestPauseStatusPayload body) throws ApiException {
        return this.updateTestPauseStatusWithHttpInfo(publicId, body).getData();
    }

    public CompletableFuture<Boolean> updateTestPauseStatusAsync(String publicId, SyntheticsUpdateTestPauseStatusPayload body) {
        return this.updateTestPauseStatusWithHttpInfoAsync(publicId, body).thenApply(response -> (Boolean)response.getData());
    }

    public ApiResponse<Boolean> updateTestPauseStatusWithHttpInfo(String publicId, SyntheticsUpdateTestPauseStatusPayload body) throws ApiException {
        SyntheticsUpdateTestPauseStatusPayload localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateTestPauseStatus");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTestPauseStatus");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/status".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SyntheticsApi.updateTestPauseStatus", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Boolean>(){});
    }

    public CompletableFuture<ApiResponse<Boolean>> updateTestPauseStatusWithHttpInfoAsync(String publicId, SyntheticsUpdateTestPauseStatusPayload body) {
        Invocation.Builder builder;
        SyntheticsUpdateTestPauseStatusPayload localVarPostBody = body;
        if (publicId == null) {
            CompletableFuture<ApiResponse<Boolean>> result = new CompletableFuture<ApiResponse<Boolean>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling updateTestPauseStatus"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Boolean>> result = new CompletableFuture<ApiResponse<Boolean>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateTestPauseStatus"));
            return result;
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/status".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SyntheticsApi.updateTestPauseStatus", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Boolean>> result = new CompletableFuture<ApiResponse<Boolean>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Boolean>(){});
    }

    public static class GetBrowserTestLatestResultsOptionalParameters {
        private Long fromTs;
        private Long toTs;
        private List<String> probeDc;

        public GetBrowserTestLatestResultsOptionalParameters fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public GetBrowserTestLatestResultsOptionalParameters toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public GetBrowserTestLatestResultsOptionalParameters probeDc(List<String> probeDc) {
            this.probeDc = probeDc;
            return this;
        }
    }

    public static class GetAPITestLatestResultsOptionalParameters {
        private Long fromTs;
        private Long toTs;
        private List<String> probeDc;

        public GetAPITestLatestResultsOptionalParameters fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public GetAPITestLatestResultsOptionalParameters toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public GetAPITestLatestResultsOptionalParameters probeDc(List<String> probeDc) {
            this.probeDc = probeDc;
            return this;
        }
    }
}

