/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.NotebookCreateRequest;
import com.datadog.api.v1.client.model.NotebookResponse;
import com.datadog.api.v1.client.model.NotebookUpdateRequest;
import com.datadog.api.v1.client.model.NotebooksResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class NotebooksApi {
    private ApiClient apiClient;

    public NotebooksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotebooksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public NotebookResponse createNotebook(NotebookCreateRequest body) throws ApiException {
        return this.createNotebookWithHttpInfo(body).getData();
    }

    public CompletableFuture<NotebookResponse> createNotebookAsync(NotebookCreateRequest body) {
        return this.createNotebookWithHttpInfoAsync(body).thenApply(response -> (NotebookResponse)response.getData());
    }

    public ApiResponse<NotebookResponse> createNotebookWithHttpInfo(NotebookCreateRequest body) throws ApiException {
        NotebookCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createNotebook");
        }
        String localVarPath = "/api/v1/notebooks";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("NotebooksApi.createNotebook", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotebookResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotebookResponse>> createNotebookWithHttpInfoAsync(NotebookCreateRequest body) {
        Invocation.Builder builder;
        NotebookCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<NotebookResponse>> result = new CompletableFuture<ApiResponse<NotebookResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createNotebook"));
            return result;
        }
        String localVarPath = "/api/v1/notebooks";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("NotebooksApi.createNotebook", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotebookResponse>> result = new CompletableFuture<ApiResponse<NotebookResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotebookResponse>(){});
    }

    public void deleteNotebook(Long notebookId) throws ApiException {
        this.deleteNotebookWithHttpInfo(notebookId);
    }

    public CompletableFuture<Void> deleteNotebookAsync(Long notebookId) {
        return this.deleteNotebookWithHttpInfoAsync(notebookId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteNotebookWithHttpInfo(Long notebookId) throws ApiException {
        Object localVarPostBody = null;
        if (notebookId == null) {
            throw new ApiException(400, "Missing the required parameter 'notebookId' when calling deleteNotebook");
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("NotebooksApi.deleteNotebook", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteNotebookWithHttpInfoAsync(Long notebookId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (notebookId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'notebookId' when calling deleteNotebook"));
            return result;
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("NotebooksApi.deleteNotebook", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public NotebookResponse getNotebook(Long notebookId) throws ApiException {
        return this.getNotebookWithHttpInfo(notebookId).getData();
    }

    public CompletableFuture<NotebookResponse> getNotebookAsync(Long notebookId) {
        return this.getNotebookWithHttpInfoAsync(notebookId).thenApply(response -> (NotebookResponse)response.getData());
    }

    public ApiResponse<NotebookResponse> getNotebookWithHttpInfo(Long notebookId) throws ApiException {
        Object localVarPostBody = null;
        if (notebookId == null) {
            throw new ApiException(400, "Missing the required parameter 'notebookId' when calling getNotebook");
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("NotebooksApi.getNotebook", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotebookResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotebookResponse>> getNotebookWithHttpInfoAsync(Long notebookId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (notebookId == null) {
            CompletableFuture<ApiResponse<NotebookResponse>> result = new CompletableFuture<ApiResponse<NotebookResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'notebookId' when calling getNotebook"));
            return result;
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("NotebooksApi.getNotebook", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotebookResponse>> result = new CompletableFuture<ApiResponse<NotebookResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotebookResponse>(){});
    }

    public NotebooksResponse listNotebooks() throws ApiException {
        return this.listNotebooksWithHttpInfo(new ListNotebooksOptionalParameters()).getData();
    }

    public CompletableFuture<NotebooksResponse> listNotebooksAsync() {
        return this.listNotebooksWithHttpInfoAsync(new ListNotebooksOptionalParameters()).thenApply(response -> (NotebooksResponse)response.getData());
    }

    public NotebooksResponse listNotebooks(ListNotebooksOptionalParameters parameters) throws ApiException {
        return this.listNotebooksWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<NotebooksResponse> listNotebooksAsync(ListNotebooksOptionalParameters parameters) {
        return this.listNotebooksWithHttpInfoAsync(parameters).thenApply(response -> (NotebooksResponse)response.getData());
    }

    public ApiResponse<NotebooksResponse> listNotebooksWithHttpInfo(ListNotebooksOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String authorHandle = parameters.authorHandle;
        String excludeAuthorHandle = parameters.excludeAuthorHandle;
        Long start = parameters.start;
        Long count = parameters.count;
        String sortField = parameters.sortField;
        String sortDir = parameters.sortDir;
        String query = parameters.query;
        Boolean includeCells = parameters.includeCells;
        Boolean isTemplate = parameters.isTemplate;
        String type = parameters.type;
        String localVarPath = "/api/v1/notebooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "author_handle", authorHandle));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "exclude_author_handle", excludeAuthorHandle));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_cells", includeCells));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "is_template", isTemplate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        Invocation.Builder builder = this.apiClient.createBuilder("NotebooksApi.listNotebooks", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotebooksResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotebooksResponse>> listNotebooksWithHttpInfoAsync(ListNotebooksOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String authorHandle = parameters.authorHandle;
        String excludeAuthorHandle = parameters.excludeAuthorHandle;
        Long start = parameters.start;
        Long count = parameters.count;
        String sortField = parameters.sortField;
        String sortDir = parameters.sortDir;
        String query = parameters.query;
        Boolean includeCells = parameters.includeCells;
        Boolean isTemplate = parameters.isTemplate;
        String type = parameters.type;
        String localVarPath = "/api/v1/notebooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "author_handle", authorHandle));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "exclude_author_handle", excludeAuthorHandle));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_cells", includeCells));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "is_template", isTemplate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        try {
            builder = this.apiClient.createBuilder("NotebooksApi.listNotebooks", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotebooksResponse>> result = new CompletableFuture<ApiResponse<NotebooksResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotebooksResponse>(){});
    }

    public NotebookResponse updateNotebook(Long notebookId, NotebookUpdateRequest body) throws ApiException {
        return this.updateNotebookWithHttpInfo(notebookId, body).getData();
    }

    public CompletableFuture<NotebookResponse> updateNotebookAsync(Long notebookId, NotebookUpdateRequest body) {
        return this.updateNotebookWithHttpInfoAsync(notebookId, body).thenApply(response -> (NotebookResponse)response.getData());
    }

    public ApiResponse<NotebookResponse> updateNotebookWithHttpInfo(Long notebookId, NotebookUpdateRequest body) throws ApiException {
        NotebookUpdateRequest localVarPostBody = body;
        if (notebookId == null) {
            throw new ApiException(400, "Missing the required parameter 'notebookId' when calling updateNotebook");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateNotebook");
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("NotebooksApi.updateNotebook", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotebookResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotebookResponse>> updateNotebookWithHttpInfoAsync(Long notebookId, NotebookUpdateRequest body) {
        Invocation.Builder builder;
        NotebookUpdateRequest localVarPostBody = body;
        if (notebookId == null) {
            CompletableFuture<ApiResponse<NotebookResponse>> result = new CompletableFuture<ApiResponse<NotebookResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'notebookId' when calling updateNotebook"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<NotebookResponse>> result = new CompletableFuture<ApiResponse<NotebookResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateNotebook"));
            return result;
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("NotebooksApi.updateNotebook", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotebookResponse>> result = new CompletableFuture<ApiResponse<NotebookResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotebookResponse>(){});
    }

    public static class ListNotebooksOptionalParameters {
        private String authorHandle;
        private String excludeAuthorHandle;
        private Long start;
        private Long count;
        private String sortField;
        private String sortDir;
        private String query;
        private Boolean includeCells;
        private Boolean isTemplate;
        private String type;

        public ListNotebooksOptionalParameters authorHandle(String authorHandle) {
            this.authorHandle = authorHandle;
            return this;
        }

        public ListNotebooksOptionalParameters excludeAuthorHandle(String excludeAuthorHandle) {
            this.excludeAuthorHandle = excludeAuthorHandle;
            return this;
        }

        public ListNotebooksOptionalParameters start(Long start) {
            this.start = start;
            return this;
        }

        public ListNotebooksOptionalParameters count(Long count) {
            this.count = count;
            return this;
        }

        public ListNotebooksOptionalParameters sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public ListNotebooksOptionalParameters sortDir(String sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public ListNotebooksOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public ListNotebooksOptionalParameters includeCells(Boolean includeCells) {
            this.includeCells = includeCells;
            return this;
        }

        public ListNotebooksOptionalParameters isTemplate(Boolean isTemplate) {
            this.isTemplate = isTemplate;
            return this;
        }

        public ListNotebooksOptionalParameters type(String type) {
            this.type = type;
            return this;
        }
    }
}

