/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.LogsIndex;
import com.datadog.api.v1.client.model.LogsIndexListResponse;
import com.datadog.api.v1.client.model.LogsIndexUpdateRequest;
import com.datadog.api.v1.client.model.LogsIndexesOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class LogsIndexesApi {
    private ApiClient apiClient;

    public LogsIndexesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsIndexesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogsIndex createLogsIndex(LogsIndex body) throws ApiException {
        return this.createLogsIndexWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsIndex> createLogsIndexAsync(LogsIndex body) {
        return this.createLogsIndexWithHttpInfoAsync(body).thenApply(response -> (LogsIndex)response.getData());
    }

    public ApiResponse<LogsIndex> createLogsIndexWithHttpInfo(LogsIndex body) throws ApiException {
        LogsIndex localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsIndex");
        }
        String localVarPath = "/api/v1/logs/config/indexes";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("LogsIndexesApi.createLogsIndex", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndex>(){});
    }

    public CompletableFuture<ApiResponse<LogsIndex>> createLogsIndexWithHttpInfoAsync(LogsIndex body) {
        Invocation.Builder builder;
        LogsIndex localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsIndex>> result = new CompletableFuture<ApiResponse<LogsIndex>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createLogsIndex"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/indexes";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsIndexesApi.createLogsIndex", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsIndex>> result = new CompletableFuture<ApiResponse<LogsIndex>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndex>(){});
    }

    public LogsIndex getLogsIndex(String name) throws ApiException {
        return this.getLogsIndexWithHttpInfo(name).getData();
    }

    public CompletableFuture<LogsIndex> getLogsIndexAsync(String name) {
        return this.getLogsIndexWithHttpInfoAsync(name).thenApply(response -> (LogsIndex)response.getData());
    }

    public ApiResponse<LogsIndex> getLogsIndexWithHttpInfo(String name) throws ApiException {
        Object localVarPostBody = null;
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling getLogsIndex");
        }
        String localVarPath = "/api/v1/logs/config/indexes/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("LogsIndexesApi.getLogsIndex", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndex>(){});
    }

    public CompletableFuture<ApiResponse<LogsIndex>> getLogsIndexWithHttpInfoAsync(String name) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (name == null) {
            CompletableFuture<ApiResponse<LogsIndex>> result = new CompletableFuture<ApiResponse<LogsIndex>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'name' when calling getLogsIndex"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/indexes/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsIndexesApi.getLogsIndex", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsIndex>> result = new CompletableFuture<ApiResponse<LogsIndex>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndex>(){});
    }

    public LogsIndexesOrder getLogsIndexOrder() throws ApiException {
        return this.getLogsIndexOrderWithHttpInfo().getData();
    }

    public CompletableFuture<LogsIndexesOrder> getLogsIndexOrderAsync() {
        return this.getLogsIndexOrderWithHttpInfoAsync().thenApply(response -> (LogsIndexesOrder)response.getData());
    }

    public ApiResponse<LogsIndexesOrder> getLogsIndexOrderWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/index-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("LogsIndexesApi.getLogsIndexOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndexesOrder>(){});
    }

    public CompletableFuture<ApiResponse<LogsIndexesOrder>> getLogsIndexOrderWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/index-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsIndexesApi.getLogsIndexOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsIndexesOrder>> result = new CompletableFuture<ApiResponse<LogsIndexesOrder>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndexesOrder>(){});
    }

    public LogsIndexListResponse listLogIndexes() throws ApiException {
        return this.listLogIndexesWithHttpInfo().getData();
    }

    public CompletableFuture<LogsIndexListResponse> listLogIndexesAsync() {
        return this.listLogIndexesWithHttpInfoAsync().thenApply(response -> (LogsIndexListResponse)response.getData());
    }

    public ApiResponse<LogsIndexListResponse> listLogIndexesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/indexes";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("LogsIndexesApi.listLogIndexes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndexListResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsIndexListResponse>> listLogIndexesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/indexes";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsIndexesApi.listLogIndexes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsIndexListResponse>> result = new CompletableFuture<ApiResponse<LogsIndexListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndexListResponse>(){});
    }

    public LogsIndex updateLogsIndex(String name, LogsIndexUpdateRequest body) throws ApiException {
        return this.updateLogsIndexWithHttpInfo(name, body).getData();
    }

    public CompletableFuture<LogsIndex> updateLogsIndexAsync(String name, LogsIndexUpdateRequest body) {
        return this.updateLogsIndexWithHttpInfoAsync(name, body).thenApply(response -> (LogsIndex)response.getData());
    }

    public ApiResponse<LogsIndex> updateLogsIndexWithHttpInfo(String name, LogsIndexUpdateRequest body) throws ApiException {
        LogsIndexUpdateRequest localVarPostBody = body;
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling updateLogsIndex");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsIndex");
        }
        String localVarPath = "/api/v1/logs/config/indexes/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("LogsIndexesApi.updateLogsIndex", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndex>(){});
    }

    public CompletableFuture<ApiResponse<LogsIndex>> updateLogsIndexWithHttpInfoAsync(String name, LogsIndexUpdateRequest body) {
        Invocation.Builder builder;
        LogsIndexUpdateRequest localVarPostBody = body;
        if (name == null) {
            CompletableFuture<ApiResponse<LogsIndex>> result = new CompletableFuture<ApiResponse<LogsIndex>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'name' when calling updateLogsIndex"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<LogsIndex>> result = new CompletableFuture<ApiResponse<LogsIndex>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateLogsIndex"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/indexes/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsIndexesApi.updateLogsIndex", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsIndex>> result = new CompletableFuture<ApiResponse<LogsIndex>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndex>(){});
    }

    public LogsIndexesOrder updateLogsIndexOrder(LogsIndexesOrder body) throws ApiException {
        return this.updateLogsIndexOrderWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsIndexesOrder> updateLogsIndexOrderAsync(LogsIndexesOrder body) {
        return this.updateLogsIndexOrderWithHttpInfoAsync(body).thenApply(response -> (LogsIndexesOrder)response.getData());
    }

    public ApiResponse<LogsIndexesOrder> updateLogsIndexOrderWithHttpInfo(LogsIndexesOrder body) throws ApiException {
        LogsIndexesOrder localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsIndexOrder");
        }
        String localVarPath = "/api/v1/logs/config/index-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("LogsIndexesApi.updateLogsIndexOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndexesOrder>(){});
    }

    public CompletableFuture<ApiResponse<LogsIndexesOrder>> updateLogsIndexOrderWithHttpInfoAsync(LogsIndexesOrder body) {
        Invocation.Builder builder;
        LogsIndexesOrder localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsIndexesOrder>> result = new CompletableFuture<ApiResponse<LogsIndexesOrder>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateLogsIndexOrder"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/index-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsIndexesApi.updateLogsIndexOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsIndexesOrder>> result = new CompletableFuture<ApiResponse<LogsIndexesOrder>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsIndexesOrder>(){});
    }
}

