/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.ResponseMetaAttributes;
import com.datadog.api.v2.client.model.User;
import com.datadog.api.v2.client.model.UserResponseIncludedItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"data", "included", "meta"})
public class UsersResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<User> data = null;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<UserResponseIncludedItem> included = null;
    public static final String JSON_PROPERTY_META = "meta";
    private ResponseMetaAttributes meta;

    public UsersResponse data(List<User> data) {
        this.data = data;
        for (User item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UsersResponse addDataItem(User dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<User>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<User> getData() {
        return this.data;
    }

    public void setData(List<User> data) {
        this.data = data;
    }

    public UsersResponse included(List<UserResponseIncludedItem> included) {
        this.included = included;
        for (UserResponseIncludedItem item : included) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UsersResponse addIncludedItem(UserResponseIncludedItem includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<UserResponseIncludedItem>();
        }
        this.included.add(includedItem);
        this.unparsed |= includedItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UserResponseIncludedItem> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<UserResponseIncludedItem> included) {
        this.included = included;
    }

    public UsersResponse meta(ResponseMetaAttributes meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponseMetaAttributes getMeta() {
        return this.meta;
    }

    public void setMeta(ResponseMetaAttributes meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersResponse usersResponse = (UsersResponse)o;
        return Objects.equals(this.data, usersResponse.data) && Objects.equals(this.included, usersResponse.included) && Objects.equals(this.meta, usersResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsersResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

