/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.UsageObservabilityPipelinesResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class UsageMeteringApi {
    private ApiClient apiClient;

    public UsageMeteringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageMeteringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UsageObservabilityPipelinesResponse getUsageObservabilityPipelines(OffsetDateTime startHr) throws ApiException {
        return this.getUsageObservabilityPipelinesWithHttpInfo(startHr, new GetUsageObservabilityPipelinesOptionalParameters()).getData();
    }

    public CompletableFuture<UsageObservabilityPipelinesResponse> getUsageObservabilityPipelinesAsync(OffsetDateTime startHr) {
        return this.getUsageObservabilityPipelinesWithHttpInfoAsync(startHr, new GetUsageObservabilityPipelinesOptionalParameters()).thenApply(response -> (UsageObservabilityPipelinesResponse)response.getData());
    }

    public UsageObservabilityPipelinesResponse getUsageObservabilityPipelines(OffsetDateTime startHr, GetUsageObservabilityPipelinesOptionalParameters parameters) throws ApiException {
        return this.getUsageObservabilityPipelinesWithHttpInfo(startHr, parameters).getData();
    }

    public CompletableFuture<UsageObservabilityPipelinesResponse> getUsageObservabilityPipelinesAsync(OffsetDateTime startHr, GetUsageObservabilityPipelinesOptionalParameters parameters) {
        return this.getUsageObservabilityPipelinesWithHttpInfoAsync(startHr, parameters).thenApply(response -> (UsageObservabilityPipelinesResponse)response.getData());
    }

    public ApiResponse<UsageObservabilityPipelinesResponse> getUsageObservabilityPipelinesWithHttpInfo(OffsetDateTime startHr, GetUsageObservabilityPipelinesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageObservabilityPipelines");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v2/usage/observability_pipelines";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        Invocation.Builder builder = this.apiClient.createBuilder("UsageMeteringApi.getUsageObservabilityPipelines", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsageObservabilityPipelinesResponse>(){});
    }

    public CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>> getUsageObservabilityPipelinesWithHttpInfoAsync(OffsetDateTime startHr, GetUsageObservabilityPipelinesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (startHr == null) {
            CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>> result = new CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageObservabilityPipelines"));
            return result;
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v2/usage/observability_pipelines";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        try {
            builder = this.apiClient.createBuilder("UsageMeteringApi.getUsageObservabilityPipelines", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>> result = new CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsageObservabilityPipelinesResponse>(){});
    }

    public static class GetUsageObservabilityPipelinesOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageObservabilityPipelinesOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }
}

