/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.EventAlertType;
import com.datadog.api.v1.client.model.EventPriority;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"aggregation_key", "alert_type", "date_happened", "device_name", "host", "priority", "related_event_id", "source_type_name", "tags", "text", "title"})
public class EventCreateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION_KEY = "aggregation_key";
    private String aggregationKey;
    public static final String JSON_PROPERTY_ALERT_TYPE = "alert_type";
    private EventAlertType alertType;
    public static final String JSON_PROPERTY_DATE_HAPPENED = "date_happened";
    private Long dateHappened;
    public static final String JSON_PROPERTY_DEVICE_NAME = "device_name";
    private String deviceName;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private JsonNullable<EventPriority> priority = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RELATED_EVENT_ID = "related_event_id";
    private Long relatedEventId;
    public static final String JSON_PROPERTY_SOURCE_TYPE_NAME = "source_type_name";
    private String sourceTypeName;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public EventCreateRequest() {
    }

    @JsonCreator
    public EventCreateRequest(@JsonProperty(required=true, value="text") String text, @JsonProperty(required=true, value="title") String title) {
        this.text = text;
        this.title = title;
    }

    public EventCreateRequest aggregationKey(String aggregationKey) {
        this.aggregationKey = aggregationKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAggregationKey() {
        return this.aggregationKey;
    }

    public void setAggregationKey(String aggregationKey) {
        this.aggregationKey = aggregationKey;
    }

    public EventCreateRequest alertType(EventAlertType alertType) {
        this.alertType = alertType;
        this.unparsed |= !alertType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="alert_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventAlertType getAlertType() {
        return this.alertType;
    }

    public void setAlertType(EventAlertType alertType) {
        if (!alertType.isValid()) {
            this.unparsed = true;
        }
        this.alertType = alertType;
    }

    public EventCreateRequest dateHappened(Long dateHappened) {
        this.dateHappened = dateHappened;
        return this;
    }

    @Nullable
    @JsonProperty(value="date_happened")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDateHappened() {
        return this.dateHappened;
    }

    public void setDateHappened(Long dateHappened) {
        this.dateHappened = dateHappened;
    }

    public EventCreateRequest deviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @Nullable
    @JsonProperty(value="device_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public EventCreateRequest host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public EventCreateRequest priority(EventPriority priority) {
        this.priority = JsonNullable.of((Object)priority);
        return this;
    }

    @Nullable
    @JsonIgnore
    public EventPriority getPriority() {
        return (EventPriority)this.priority.orElse(null);
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<EventPriority> getPriority_JsonNullable() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority_JsonNullable(JsonNullable<EventPriority> priority) {
        this.priority = priority;
    }

    public void setPriority(EventPriority priority) {
        if (!priority.isValid()) {
            this.unparsed = true;
        }
        this.priority = JsonNullable.of((Object)priority);
    }

    public EventCreateRequest relatedEventId(Long relatedEventId) {
        this.relatedEventId = relatedEventId;
        return this;
    }

    @Nullable
    @JsonProperty(value="related_event_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRelatedEventId() {
        return this.relatedEventId;
    }

    public void setRelatedEventId(Long relatedEventId) {
        this.relatedEventId = relatedEventId;
    }

    public EventCreateRequest sourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
        return this;
    }

    @Nullable
    @JsonProperty(value="source_type_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public EventCreateRequest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public EventCreateRequest addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public EventCreateRequest text(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public EventCreateRequest title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCreateRequest eventCreateRequest = (EventCreateRequest)o;
        return Objects.equals(this.aggregationKey, eventCreateRequest.aggregationKey) && Objects.equals(this.alertType, eventCreateRequest.alertType) && Objects.equals(this.dateHappened, eventCreateRequest.dateHappened) && Objects.equals(this.deviceName, eventCreateRequest.deviceName) && Objects.equals(this.host, eventCreateRequest.host) && Objects.equals(this.priority, eventCreateRequest.priority) && Objects.equals(this.relatedEventId, eventCreateRequest.relatedEventId) && Objects.equals(this.sourceTypeName, eventCreateRequest.sourceTypeName) && Objects.equals(this.tags, eventCreateRequest.tags) && Objects.equals(this.text, eventCreateRequest.text) && Objects.equals(this.title, eventCreateRequest.title);
    }

    public int hashCode() {
        return Objects.hash(this.aggregationKey, this.alertType, this.dateHappened, this.deviceName, this.host, this.priority, this.relatedEventId, this.sourceTypeName, this.tags, this.text, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventCreateRequest {\n");
        sb.append("    aggregationKey: ").append(this.toIndentedString(this.aggregationKey)).append("\n");
        sb.append("    alertType: ").append(this.toIndentedString(this.alertType)).append("\n");
        sb.append("    dateHappened: ").append(this.toIndentedString(this.dateHappened)).append("\n");
        sb.append("    deviceName: ").append(this.toIndentedString(this.deviceName)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    relatedEventId: ").append(this.toIndentedString(this.relatedEventId)).append("\n");
        sb.append("    sourceTypeName: ").append(this.toIndentedString(this.sourceTypeName)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

