/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Attributes of AuthN Mapping.")
@JsonPropertyOrder(value={"attribute_key", "attribute_value", "created_at", "modified_at", "saml_assertion_attribute_id"})
public class AuthNMappingAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTE_KEY = "attribute_key";
    private String attributeKey;
    public static final String JSON_PROPERTY_ATTRIBUTE_VALUE = "attribute_value";
    private String attributeValue;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_SAML_ASSERTION_ATTRIBUTE_ID = "saml_assertion_attribute_id";
    private Integer samlAssertionAttributeId;

    public AuthNMappingAttributes attributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="member-of", value="Key portion of a key/value pair of the attribute sent from the Identity Provider.")
    @JsonProperty(value="attribute_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
    }

    public AuthNMappingAttributes attributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Development", value="Value portion of a key/value pair of the attribute sent from the Identity Provider.")
    @JsonProperty(value="attribute_value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    @Nullable
    @ApiModelProperty(value="Creation time of the AuthN Mapping.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="Time of last AuthN Mapping modification.")
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public AuthNMappingAttributes samlAssertionAttributeId(Integer samlAssertionAttributeId) {
        this.samlAssertionAttributeId = samlAssertionAttributeId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="The ID of the SAML assertion attribute.")
    @JsonProperty(value="saml_assertion_attribute_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSamlAssertionAttributeId() {
        return this.samlAssertionAttributeId;
    }

    public void setSamlAssertionAttributeId(Integer samlAssertionAttributeId) {
        this.samlAssertionAttributeId = samlAssertionAttributeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthNMappingAttributes authNMappingAttributes = (AuthNMappingAttributes)o;
        return Objects.equals(this.attributeKey, authNMappingAttributes.attributeKey) && Objects.equals(this.attributeValue, authNMappingAttributes.attributeValue) && Objects.equals(this.createdAt, authNMappingAttributes.createdAt) && Objects.equals(this.modifiedAt, authNMappingAttributes.modifiedAt) && Objects.equals(this.samlAssertionAttributeId, authNMappingAttributes.samlAssertionAttributeId);
    }

    public int hashCode() {
        return Objects.hash(this.attributeKey, this.attributeValue, this.createdAt, this.modifiedAt, this.samlAssertionAttributeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthNMappingAttributes {\n");
        sb.append("    attributeKey: ").append(this.toIndentedString(this.attributeKey)).append("\n");
        sb.append("    attributeValue: ").append(this.toIndentedString(this.attributeValue)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    samlAssertionAttributeId: ").append(this.toIndentedString(this.samlAssertionAttributeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

