/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOTimeframe;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SLO thresholds (target and optionally warning) for a single time window.")
@JsonPropertyOrder(value={"target", "target_display", "timeframe", "warning", "warning_display"})
public class SLOThreshold {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_TARGET = "target";
    private Double target;
    public static final String JSON_PROPERTY_TARGET_DISPLAY = "target_display";
    private String targetDisplay;
    public static final String JSON_PROPERTY_TIMEFRAME = "timeframe";
    private SLOTimeframe timeframe;
    public static final String JSON_PROPERTY_WARNING = "warning";
    private Double warning;
    public static final String JSON_PROPERTY_WARNING_DISPLAY = "warning_display";
    private String warningDisplay;

    public SLOThreshold() {
    }

    @JsonCreator
    public SLOThreshold(@JsonProperty(required=true, value="target") Double target, @JsonProperty(required=true, value="timeframe") SLOTimeframe timeframe) {
        this.target = target;
        this.timeframe = timeframe;
        this.unparsed |= !timeframe.isValid();
    }

    public SLOThreshold target(Double target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="99.9", required=true, value="The target value for the service level indicator within the corresponding timeframe.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getTarget() {
        return this.target;
    }

    public void setTarget(Double target) {
        this.target = target;
    }

    public SLOThreshold targetDisplay(String targetDisplay) {
        this.targetDisplay = targetDisplay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="99.9", value="A string representation of the target that indicates its precision. It uses trailing zeros to show significant decimal places (for example `98.00`).  Always included in service level objective responses. Ignored in create/update requests.")
    @JsonProperty(value="target_display")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetDisplay() {
        return this.targetDisplay;
    }

    public void setTargetDisplay(String targetDisplay) {
        this.targetDisplay = targetDisplay;
    }

    public SLOThreshold timeframe(SLOTimeframe timeframe) {
        this.timeframe = timeframe;
        this.unparsed |= !timeframe.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="timeframe")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOTimeframe getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(SLOTimeframe timeframe) {
        if (!timeframe.isValid()) {
            this.unparsed = true;
        }
        this.timeframe = timeframe;
    }

    public SLOThreshold warning(Double warning) {
        this.warning = warning;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="90.0", value="The warning value for the service level objective.")
    @JsonProperty(value="warning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getWarning() {
        return this.warning;
    }

    public void setWarning(Double warning) {
        this.warning = warning;
    }

    public SLOThreshold warningDisplay(String warningDisplay) {
        this.warningDisplay = warningDisplay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="90.0", value="A string representation of the warning target (see the description of the `target_display` field for details).  Included in service level objective responses if a warning target exists. Ignored in create/update requests.")
    @JsonProperty(value="warning_display")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWarningDisplay() {
        return this.warningDisplay;
    }

    public void setWarningDisplay(String warningDisplay) {
        this.warningDisplay = warningDisplay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOThreshold slOThreshold = (SLOThreshold)o;
        return Objects.equals(this.target, slOThreshold.target) && Objects.equals(this.targetDisplay, slOThreshold.targetDisplay) && Objects.equals(this.timeframe, slOThreshold.timeframe) && Objects.equals(this.warning, slOThreshold.warning) && Objects.equals(this.warningDisplay, slOThreshold.warningDisplay);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.targetDisplay, this.timeframe, this.warning, this.warningDisplay);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOThreshold {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    targetDisplay: ").append(this.toIndentedString(this.targetDisplay)).append("\n");
        sb.append("    timeframe: ").append(this.toIndentedString(this.timeframe)).append("\n");
        sb.append("    warning: ").append(this.toIndentedString(this.warning)).append("\n");
        sb.append("    warningDisplay: ").append(this.toIndentedString(this.warningDisplay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

