/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fields in Usage Summary by tag(s).")
@JsonPropertyOrder(value={"api_percentage", "api_usage", "apm_host_percentage", "apm_host_usage", "browser_percentage", "browser_usage", "container_percentage", "container_usage", "custom_timeseries_percentage", "custom_timeseries_usage", "estimated_indexed_logs_percentage", "estimated_indexed_logs_usage", "fargate_percentage", "fargate_usage", "functions_percentage", "functions_usage", "indexed_logs_percentage", "indexed_logs_usage", "infra_host_percentage", "infra_host_usage", "invocations_percentage", "invocations_usage", "npm_host_percentage", "npm_host_usage", "profiled_container_percentage", "profiled_container_usage", "profiled_host_percentage", "profiled_host_usage", "snmp_percentage", "snmp_usage"})
public class MonthlyUsageAttributionValues {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_PERCENTAGE = "api_percentage";
    private Double apiPercentage;
    public static final String JSON_PROPERTY_API_USAGE = "api_usage";
    private Double apiUsage;
    public static final String JSON_PROPERTY_APM_HOST_PERCENTAGE = "apm_host_percentage";
    private Double apmHostPercentage;
    public static final String JSON_PROPERTY_APM_HOST_USAGE = "apm_host_usage";
    private Double apmHostUsage;
    public static final String JSON_PROPERTY_BROWSER_PERCENTAGE = "browser_percentage";
    private Double browserPercentage;
    public static final String JSON_PROPERTY_BROWSER_USAGE = "browser_usage";
    private Double browserUsage;
    public static final String JSON_PROPERTY_CONTAINER_PERCENTAGE = "container_percentage";
    private Double containerPercentage;
    public static final String JSON_PROPERTY_CONTAINER_USAGE = "container_usage";
    private Double containerUsage;
    public static final String JSON_PROPERTY_CUSTOM_TIMESERIES_PERCENTAGE = "custom_timeseries_percentage";
    private Double customTimeseriesPercentage;
    public static final String JSON_PROPERTY_CUSTOM_TIMESERIES_USAGE = "custom_timeseries_usage";
    private Double customTimeseriesUsage;
    public static final String JSON_PROPERTY_ESTIMATED_INDEXED_LOGS_PERCENTAGE = "estimated_indexed_logs_percentage";
    private Double estimatedIndexedLogsPercentage;
    public static final String JSON_PROPERTY_ESTIMATED_INDEXED_LOGS_USAGE = "estimated_indexed_logs_usage";
    private Double estimatedIndexedLogsUsage;
    public static final String JSON_PROPERTY_FARGATE_PERCENTAGE = "fargate_percentage";
    private Double fargatePercentage;
    public static final String JSON_PROPERTY_FARGATE_USAGE = "fargate_usage";
    private Double fargateUsage;
    public static final String JSON_PROPERTY_FUNCTIONS_PERCENTAGE = "functions_percentage";
    private Double functionsPercentage;
    public static final String JSON_PROPERTY_FUNCTIONS_USAGE = "functions_usage";
    private Double functionsUsage;
    public static final String JSON_PROPERTY_INDEXED_LOGS_PERCENTAGE = "indexed_logs_percentage";
    private Double indexedLogsPercentage;
    public static final String JSON_PROPERTY_INDEXED_LOGS_USAGE = "indexed_logs_usage";
    private Double indexedLogsUsage;
    public static final String JSON_PROPERTY_INFRA_HOST_PERCENTAGE = "infra_host_percentage";
    private Double infraHostPercentage;
    public static final String JSON_PROPERTY_INFRA_HOST_USAGE = "infra_host_usage";
    private Double infraHostUsage;
    public static final String JSON_PROPERTY_INVOCATIONS_PERCENTAGE = "invocations_percentage";
    private Double invocationsPercentage;
    public static final String JSON_PROPERTY_INVOCATIONS_USAGE = "invocations_usage";
    private Double invocationsUsage;
    public static final String JSON_PROPERTY_NPM_HOST_PERCENTAGE = "npm_host_percentage";
    private Double npmHostPercentage;
    public static final String JSON_PROPERTY_NPM_HOST_USAGE = "npm_host_usage";
    private Double npmHostUsage;
    public static final String JSON_PROPERTY_PROFILED_CONTAINER_PERCENTAGE = "profiled_container_percentage";
    private Double profiledContainerPercentage;
    public static final String JSON_PROPERTY_PROFILED_CONTAINER_USAGE = "profiled_container_usage";
    private Double profiledContainerUsage;
    public static final String JSON_PROPERTY_PROFILED_HOST_PERCENTAGE = "profiled_host_percentage";
    private Double profiledHostPercentage;
    public static final String JSON_PROPERTY_PROFILED_HOST_USAGE = "profiled_host_usage";
    private Double profiledHostUsage;
    public static final String JSON_PROPERTY_SNMP_PERCENTAGE = "snmp_percentage";
    private Double snmpPercentage;
    public static final String JSON_PROPERTY_SNMP_USAGE = "snmp_usage";
    private Double snmpUsage;

    public MonthlyUsageAttributionValues apiPercentage(Double apiPercentage) {
        this.apiPercentage = apiPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of synthetic API test usage by tag(s).")
    @JsonProperty(value="api_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getApiPercentage() {
        return this.apiPercentage;
    }

    public void setApiPercentage(Double apiPercentage) {
        this.apiPercentage = apiPercentage;
    }

    public MonthlyUsageAttributionValues apiUsage(Double apiUsage) {
        this.apiUsage = apiUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The synthetic API test usage by tag(s).")
    @JsonProperty(value="api_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getApiUsage() {
        return this.apiUsage;
    }

    public void setApiUsage(Double apiUsage) {
        this.apiUsage = apiUsage;
    }

    public MonthlyUsageAttributionValues apmHostPercentage(Double apmHostPercentage) {
        this.apmHostPercentage = apmHostPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of APM host usage by tag(s).")
    @JsonProperty(value="apm_host_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getApmHostPercentage() {
        return this.apmHostPercentage;
    }

    public void setApmHostPercentage(Double apmHostPercentage) {
        this.apmHostPercentage = apmHostPercentage;
    }

    public MonthlyUsageAttributionValues apmHostUsage(Double apmHostUsage) {
        this.apmHostUsage = apmHostUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The APM host usage by tag(s).")
    @JsonProperty(value="apm_host_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getApmHostUsage() {
        return this.apmHostUsage;
    }

    public void setApmHostUsage(Double apmHostUsage) {
        this.apmHostUsage = apmHostUsage;
    }

    public MonthlyUsageAttributionValues browserPercentage(Double browserPercentage) {
        this.browserPercentage = browserPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of synthetic browser test usage by tag(s).")
    @JsonProperty(value="browser_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getBrowserPercentage() {
        return this.browserPercentage;
    }

    public void setBrowserPercentage(Double browserPercentage) {
        this.browserPercentage = browserPercentage;
    }

    public MonthlyUsageAttributionValues browserUsage(Double browserUsage) {
        this.browserUsage = browserUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The synthetic browser test usage by tag(s).")
    @JsonProperty(value="browser_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getBrowserUsage() {
        return this.browserUsage;
    }

    public void setBrowserUsage(Double browserUsage) {
        this.browserUsage = browserUsage;
    }

    public MonthlyUsageAttributionValues containerPercentage(Double containerPercentage) {
        this.containerPercentage = containerPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of container usage by tag(s).")
    @JsonProperty(value="container_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getContainerPercentage() {
        return this.containerPercentage;
    }

    public void setContainerPercentage(Double containerPercentage) {
        this.containerPercentage = containerPercentage;
    }

    public MonthlyUsageAttributionValues containerUsage(Double containerUsage) {
        this.containerUsage = containerUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The container usage by tag(s).")
    @JsonProperty(value="container_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getContainerUsage() {
        return this.containerUsage;
    }

    public void setContainerUsage(Double containerUsage) {
        this.containerUsage = containerUsage;
    }

    public MonthlyUsageAttributionValues customTimeseriesPercentage(Double customTimeseriesPercentage) {
        this.customTimeseriesPercentage = customTimeseriesPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of custom metrics usage by tag(s).")
    @JsonProperty(value="custom_timeseries_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getCustomTimeseriesPercentage() {
        return this.customTimeseriesPercentage;
    }

    public void setCustomTimeseriesPercentage(Double customTimeseriesPercentage) {
        this.customTimeseriesPercentage = customTimeseriesPercentage;
    }

    public MonthlyUsageAttributionValues customTimeseriesUsage(Double customTimeseriesUsage) {
        this.customTimeseriesUsage = customTimeseriesUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The custom metrics usage by tag(s).")
    @JsonProperty(value="custom_timeseries_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getCustomTimeseriesUsage() {
        return this.customTimeseriesUsage;
    }

    public void setCustomTimeseriesUsage(Double customTimeseriesUsage) {
        this.customTimeseriesUsage = customTimeseriesUsage;
    }

    public MonthlyUsageAttributionValues estimatedIndexedLogsPercentage(Double estimatedIndexedLogsPercentage) {
        this.estimatedIndexedLogsPercentage = estimatedIndexedLogsPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of estimated live indexed logs usage by tag(s). This field is in private beta.")
    @JsonProperty(value="estimated_indexed_logs_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getEstimatedIndexedLogsPercentage() {
        return this.estimatedIndexedLogsPercentage;
    }

    public void setEstimatedIndexedLogsPercentage(Double estimatedIndexedLogsPercentage) {
        this.estimatedIndexedLogsPercentage = estimatedIndexedLogsPercentage;
    }

    public MonthlyUsageAttributionValues estimatedIndexedLogsUsage(Double estimatedIndexedLogsUsage) {
        this.estimatedIndexedLogsUsage = estimatedIndexedLogsUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The estimated live indexed logs usage by tag(s). This field is in private beta.")
    @JsonProperty(value="estimated_indexed_logs_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getEstimatedIndexedLogsUsage() {
        return this.estimatedIndexedLogsUsage;
    }

    public void setEstimatedIndexedLogsUsage(Double estimatedIndexedLogsUsage) {
        this.estimatedIndexedLogsUsage = estimatedIndexedLogsUsage;
    }

    public MonthlyUsageAttributionValues fargatePercentage(Double fargatePercentage) {
        this.fargatePercentage = fargatePercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of Fargate usage by tags.")
    @JsonProperty(value="fargate_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getFargatePercentage() {
        return this.fargatePercentage;
    }

    public void setFargatePercentage(Double fargatePercentage) {
        this.fargatePercentage = fargatePercentage;
    }

    public MonthlyUsageAttributionValues fargateUsage(Double fargateUsage) {
        this.fargateUsage = fargateUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Fargate usage by tags.")
    @JsonProperty(value="fargate_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getFargateUsage() {
        return this.fargateUsage;
    }

    public void setFargateUsage(Double fargateUsage) {
        this.fargateUsage = fargateUsage;
    }

    public MonthlyUsageAttributionValues functionsPercentage(Double functionsPercentage) {
        this.functionsPercentage = functionsPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of Lambda function usage by tag(s).")
    @JsonProperty(value="functions_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getFunctionsPercentage() {
        return this.functionsPercentage;
    }

    public void setFunctionsPercentage(Double functionsPercentage) {
        this.functionsPercentage = functionsPercentage;
    }

    public MonthlyUsageAttributionValues functionsUsage(Double functionsUsage) {
        this.functionsUsage = functionsUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Lambda function usage by tag(s).")
    @JsonProperty(value="functions_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getFunctionsUsage() {
        return this.functionsUsage;
    }

    public void setFunctionsUsage(Double functionsUsage) {
        this.functionsUsage = functionsUsage;
    }

    public MonthlyUsageAttributionValues indexedLogsPercentage(Double indexedLogsPercentage) {
        this.indexedLogsPercentage = indexedLogsPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of indexed logs usage by tags.")
    @JsonProperty(value="indexed_logs_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getIndexedLogsPercentage() {
        return this.indexedLogsPercentage;
    }

    public void setIndexedLogsPercentage(Double indexedLogsPercentage) {
        this.indexedLogsPercentage = indexedLogsPercentage;
    }

    public MonthlyUsageAttributionValues indexedLogsUsage(Double indexedLogsUsage) {
        this.indexedLogsUsage = indexedLogsUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The indexed logs usage by tags.")
    @JsonProperty(value="indexed_logs_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getIndexedLogsUsage() {
        return this.indexedLogsUsage;
    }

    public void setIndexedLogsUsage(Double indexedLogsUsage) {
        this.indexedLogsUsage = indexedLogsUsage;
    }

    public MonthlyUsageAttributionValues infraHostPercentage(Double infraHostPercentage) {
        this.infraHostPercentage = infraHostPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of infrastructure host usage by tag(s).")
    @JsonProperty(value="infra_host_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInfraHostPercentage() {
        return this.infraHostPercentage;
    }

    public void setInfraHostPercentage(Double infraHostPercentage) {
        this.infraHostPercentage = infraHostPercentage;
    }

    public MonthlyUsageAttributionValues infraHostUsage(Double infraHostUsage) {
        this.infraHostUsage = infraHostUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The infrastructure host usage by tag(s).")
    @JsonProperty(value="infra_host_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInfraHostUsage() {
        return this.infraHostUsage;
    }

    public void setInfraHostUsage(Double infraHostUsage) {
        this.infraHostUsage = infraHostUsage;
    }

    public MonthlyUsageAttributionValues invocationsPercentage(Double invocationsPercentage) {
        this.invocationsPercentage = invocationsPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of Lambda invocation usage by tag(s).")
    @JsonProperty(value="invocations_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInvocationsPercentage() {
        return this.invocationsPercentage;
    }

    public void setInvocationsPercentage(Double invocationsPercentage) {
        this.invocationsPercentage = invocationsPercentage;
    }

    public MonthlyUsageAttributionValues invocationsUsage(Double invocationsUsage) {
        this.invocationsUsage = invocationsUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Lambda invocation usage by tag(s).")
    @JsonProperty(value="invocations_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInvocationsUsage() {
        return this.invocationsUsage;
    }

    public void setInvocationsUsage(Double invocationsUsage) {
        this.invocationsUsage = invocationsUsage;
    }

    public MonthlyUsageAttributionValues npmHostPercentage(Double npmHostPercentage) {
        this.npmHostPercentage = npmHostPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of network host usage by tag(s).")
    @JsonProperty(value="npm_host_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNpmHostPercentage() {
        return this.npmHostPercentage;
    }

    public void setNpmHostPercentage(Double npmHostPercentage) {
        this.npmHostPercentage = npmHostPercentage;
    }

    public MonthlyUsageAttributionValues npmHostUsage(Double npmHostUsage) {
        this.npmHostUsage = npmHostUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network host usage by tag(s).")
    @JsonProperty(value="npm_host_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNpmHostUsage() {
        return this.npmHostUsage;
    }

    public void setNpmHostUsage(Double npmHostUsage) {
        this.npmHostUsage = npmHostUsage;
    }

    public MonthlyUsageAttributionValues profiledContainerPercentage(Double profiledContainerPercentage) {
        this.profiledContainerPercentage = profiledContainerPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of profiled container usage by tag(s).")
    @JsonProperty(value="profiled_container_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfiledContainerPercentage() {
        return this.profiledContainerPercentage;
    }

    public void setProfiledContainerPercentage(Double profiledContainerPercentage) {
        this.profiledContainerPercentage = profiledContainerPercentage;
    }

    public MonthlyUsageAttributionValues profiledContainerUsage(Double profiledContainerUsage) {
        this.profiledContainerUsage = profiledContainerUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The profiled container usage by tag(s).")
    @JsonProperty(value="profiled_container_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfiledContainerUsage() {
        return this.profiledContainerUsage;
    }

    public void setProfiledContainerUsage(Double profiledContainerUsage) {
        this.profiledContainerUsage = profiledContainerUsage;
    }

    public MonthlyUsageAttributionValues profiledHostPercentage(Double profiledHostPercentage) {
        this.profiledHostPercentage = profiledHostPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of profiled hosts usage by tag(s).")
    @JsonProperty(value="profiled_host_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfiledHostPercentage() {
        return this.profiledHostPercentage;
    }

    public void setProfiledHostPercentage(Double profiledHostPercentage) {
        this.profiledHostPercentage = profiledHostPercentage;
    }

    public MonthlyUsageAttributionValues profiledHostUsage(Double profiledHostUsage) {
        this.profiledHostUsage = profiledHostUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The profiled hosts usage by tag(s).")
    @JsonProperty(value="profiled_host_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfiledHostUsage() {
        return this.profiledHostUsage;
    }

    public void setProfiledHostUsage(Double profiledHostUsage) {
        this.profiledHostUsage = profiledHostUsage;
    }

    public MonthlyUsageAttributionValues snmpPercentage(Double snmpPercentage) {
        this.snmpPercentage = snmpPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of network device usage by tag(s).")
    @JsonProperty(value="snmp_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSnmpPercentage() {
        return this.snmpPercentage;
    }

    public void setSnmpPercentage(Double snmpPercentage) {
        this.snmpPercentage = snmpPercentage;
    }

    public MonthlyUsageAttributionValues snmpUsage(Double snmpUsage) {
        this.snmpUsage = snmpUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network device usage by tag(s).")
    @JsonProperty(value="snmp_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSnmpUsage() {
        return this.snmpUsage;
    }

    public void setSnmpUsage(Double snmpUsage) {
        this.snmpUsage = snmpUsage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonthlyUsageAttributionValues monthlyUsageAttributionValues = (MonthlyUsageAttributionValues)o;
        return Objects.equals(this.apiPercentage, monthlyUsageAttributionValues.apiPercentage) && Objects.equals(this.apiUsage, monthlyUsageAttributionValues.apiUsage) && Objects.equals(this.apmHostPercentage, monthlyUsageAttributionValues.apmHostPercentage) && Objects.equals(this.apmHostUsage, monthlyUsageAttributionValues.apmHostUsage) && Objects.equals(this.browserPercentage, monthlyUsageAttributionValues.browserPercentage) && Objects.equals(this.browserUsage, monthlyUsageAttributionValues.browserUsage) && Objects.equals(this.containerPercentage, monthlyUsageAttributionValues.containerPercentage) && Objects.equals(this.containerUsage, monthlyUsageAttributionValues.containerUsage) && Objects.equals(this.customTimeseriesPercentage, monthlyUsageAttributionValues.customTimeseriesPercentage) && Objects.equals(this.customTimeseriesUsage, monthlyUsageAttributionValues.customTimeseriesUsage) && Objects.equals(this.estimatedIndexedLogsPercentage, monthlyUsageAttributionValues.estimatedIndexedLogsPercentage) && Objects.equals(this.estimatedIndexedLogsUsage, monthlyUsageAttributionValues.estimatedIndexedLogsUsage) && Objects.equals(this.fargatePercentage, monthlyUsageAttributionValues.fargatePercentage) && Objects.equals(this.fargateUsage, monthlyUsageAttributionValues.fargateUsage) && Objects.equals(this.functionsPercentage, monthlyUsageAttributionValues.functionsPercentage) && Objects.equals(this.functionsUsage, monthlyUsageAttributionValues.functionsUsage) && Objects.equals(this.indexedLogsPercentage, monthlyUsageAttributionValues.indexedLogsPercentage) && Objects.equals(this.indexedLogsUsage, monthlyUsageAttributionValues.indexedLogsUsage) && Objects.equals(this.infraHostPercentage, monthlyUsageAttributionValues.infraHostPercentage) && Objects.equals(this.infraHostUsage, monthlyUsageAttributionValues.infraHostUsage) && Objects.equals(this.invocationsPercentage, monthlyUsageAttributionValues.invocationsPercentage) && Objects.equals(this.invocationsUsage, monthlyUsageAttributionValues.invocationsUsage) && Objects.equals(this.npmHostPercentage, monthlyUsageAttributionValues.npmHostPercentage) && Objects.equals(this.npmHostUsage, monthlyUsageAttributionValues.npmHostUsage) && Objects.equals(this.profiledContainerPercentage, monthlyUsageAttributionValues.profiledContainerPercentage) && Objects.equals(this.profiledContainerUsage, monthlyUsageAttributionValues.profiledContainerUsage) && Objects.equals(this.profiledHostPercentage, monthlyUsageAttributionValues.profiledHostPercentage) && Objects.equals(this.profiledHostUsage, monthlyUsageAttributionValues.profiledHostUsage) && Objects.equals(this.snmpPercentage, monthlyUsageAttributionValues.snmpPercentage) && Objects.equals(this.snmpUsage, monthlyUsageAttributionValues.snmpUsage);
    }

    public int hashCode() {
        return Objects.hash(this.apiPercentage, this.apiUsage, this.apmHostPercentage, this.apmHostUsage, this.browserPercentage, this.browserUsage, this.containerPercentage, this.containerUsage, this.customTimeseriesPercentage, this.customTimeseriesUsage, this.estimatedIndexedLogsPercentage, this.estimatedIndexedLogsUsage, this.fargatePercentage, this.fargateUsage, this.functionsPercentage, this.functionsUsage, this.indexedLogsPercentage, this.indexedLogsUsage, this.infraHostPercentage, this.infraHostUsage, this.invocationsPercentage, this.invocationsUsage, this.npmHostPercentage, this.npmHostUsage, this.profiledContainerPercentage, this.profiledContainerUsage, this.profiledHostPercentage, this.profiledHostUsage, this.snmpPercentage, this.snmpUsage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonthlyUsageAttributionValues {\n");
        sb.append("    apiPercentage: ").append(this.toIndentedString(this.apiPercentage)).append("\n");
        sb.append("    apiUsage: ").append(this.toIndentedString(this.apiUsage)).append("\n");
        sb.append("    apmHostPercentage: ").append(this.toIndentedString(this.apmHostPercentage)).append("\n");
        sb.append("    apmHostUsage: ").append(this.toIndentedString(this.apmHostUsage)).append("\n");
        sb.append("    browserPercentage: ").append(this.toIndentedString(this.browserPercentage)).append("\n");
        sb.append("    browserUsage: ").append(this.toIndentedString(this.browserUsage)).append("\n");
        sb.append("    containerPercentage: ").append(this.toIndentedString(this.containerPercentage)).append("\n");
        sb.append("    containerUsage: ").append(this.toIndentedString(this.containerUsage)).append("\n");
        sb.append("    customTimeseriesPercentage: ").append(this.toIndentedString(this.customTimeseriesPercentage)).append("\n");
        sb.append("    customTimeseriesUsage: ").append(this.toIndentedString(this.customTimeseriesUsage)).append("\n");
        sb.append("    estimatedIndexedLogsPercentage: ").append(this.toIndentedString(this.estimatedIndexedLogsPercentage)).append("\n");
        sb.append("    estimatedIndexedLogsUsage: ").append(this.toIndentedString(this.estimatedIndexedLogsUsage)).append("\n");
        sb.append("    fargatePercentage: ").append(this.toIndentedString(this.fargatePercentage)).append("\n");
        sb.append("    fargateUsage: ").append(this.toIndentedString(this.fargateUsage)).append("\n");
        sb.append("    functionsPercentage: ").append(this.toIndentedString(this.functionsPercentage)).append("\n");
        sb.append("    functionsUsage: ").append(this.toIndentedString(this.functionsUsage)).append("\n");
        sb.append("    indexedLogsPercentage: ").append(this.toIndentedString(this.indexedLogsPercentage)).append("\n");
        sb.append("    indexedLogsUsage: ").append(this.toIndentedString(this.indexedLogsUsage)).append("\n");
        sb.append("    infraHostPercentage: ").append(this.toIndentedString(this.infraHostPercentage)).append("\n");
        sb.append("    infraHostUsage: ").append(this.toIndentedString(this.infraHostUsage)).append("\n");
        sb.append("    invocationsPercentage: ").append(this.toIndentedString(this.invocationsPercentage)).append("\n");
        sb.append("    invocationsUsage: ").append(this.toIndentedString(this.invocationsUsage)).append("\n");
        sb.append("    npmHostPercentage: ").append(this.toIndentedString(this.npmHostPercentage)).append("\n");
        sb.append("    npmHostUsage: ").append(this.toIndentedString(this.npmHostUsage)).append("\n");
        sb.append("    profiledContainerPercentage: ").append(this.toIndentedString(this.profiledContainerPercentage)).append("\n");
        sb.append("    profiledContainerUsage: ").append(this.toIndentedString(this.profiledContainerUsage)).append("\n");
        sb.append("    profiledHostPercentage: ").append(this.toIndentedString(this.profiledHostPercentage)).append("\n");
        sb.append("    profiledHostUsage: ").append(this.toIndentedString(this.profiledHostUsage)).append("\n");
        sb.append("    snmpPercentage: ").append(this.toIndentedString(this.snmpPercentage)).append("\n");
        sb.append("    snmpUsage: ").append(this.toIndentedString(this.snmpUsage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

