/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Logs that are sent over HTTP.")
@JsonPropertyOrder(value={"ddsource", "ddtags", "hostname", "message", "service"})
public class HTTPLogItem {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DDSOURCE = "ddsource";
    private String ddsource;
    public static final String JSON_PROPERTY_DDTAGS = "ddtags";
    private String ddtags;
    public static final String JSON_PROPERTY_HOSTNAME = "hostname";
    private String hostname;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;

    public HTTPLogItem() {
    }

    @JsonCreator
    public HTTPLogItem(@JsonProperty(required=true, value="message") String message) {
        this.message = message;
    }

    public HTTPLogItem ddsource(String ddsource) {
        this.ddsource = ddsource;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="nginx", value="The integration name associated with your log: the technology from which the log originated. When it matches an integration name, Datadog automatically installs the corresponding parsers and facets. See [reserved attributes](https://docs.datadoghq.com/logs/log_collection/#reserved-attributes).")
    @JsonProperty(value="ddsource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDdsource() {
        return this.ddsource;
    }

    public void setDdsource(String ddsource) {
        this.ddsource = ddsource;
    }

    public HTTPLogItem ddtags(String ddtags) {
        this.ddtags = ddtags;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="env:staging,version:5.1", value="Tags associated with your logs.")
    @JsonProperty(value="ddtags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDdtags() {
        return this.ddtags;
    }

    public void setDdtags(String ddtags) {
        this.ddtags = ddtags;
    }

    public HTTPLogItem hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="i-012345678", value="The name of the originating host of the log.")
    @JsonProperty(value="hostname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public HTTPLogItem message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="2019-11-19T14:37:58,995 INFO [process.name][20081] Hello World", required=true, value="The message [reserved attribute](https://docs.datadoghq.com/logs/log_collection/#reserved-attributes) of your log. By default, Datadog ingests the value of the message attribute as the body of the log entry. That value is then highlighted and displayed in the Logstream, where it is indexed for full text search.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public HTTPLogItem service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="payment", value="The name of the application or service generating the log events. It is used to switch from Logs to APM, so make sure you define the same value when you use both products. See [reserved attributes](https://docs.datadoghq.com/logs/log_collection/#reserved-attributes).")
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPLogItem htTPLogItem = (HTTPLogItem)o;
        return Objects.equals(this.ddsource, htTPLogItem.ddsource) && Objects.equals(this.ddtags, htTPLogItem.ddtags) && Objects.equals(this.hostname, htTPLogItem.hostname) && Objects.equals(this.message, htTPLogItem.message) && Objects.equals(this.service, htTPLogItem.service);
    }

    public int hashCode() {
        return Objects.hash(this.ddsource, this.ddtags, this.hostname, this.message, this.service);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HTTPLogItem {\n");
        sb.append("    ddsource: ").append(this.toIndentedString(this.ddsource)).append("\n");
        sb.append("    ddtags: ").append(this.toIndentedString(this.ddtags)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

