/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.AWSAccountAndLambdaRequest;
import com.datadog.api.v1.client.model.AWSLogsAsyncResponse;
import com.datadog.api.v1.client.model.AWSLogsListResponse;
import com.datadog.api.v1.client.model.AWSLogsListServicesResponse;
import com.datadog.api.v1.client.model.AWSLogsServicesRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class AwsLogsIntegrationApi {
    private ApiClient apiClient;

    public AwsLogsIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AwsLogsIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AWSLogsAsyncResponse checkAWSLogsLambdaAsync(AWSAccountAndLambdaRequest body) throws ApiException {
        return this.checkAWSLogsLambdaAsyncWithHttpInfo(body).getData();
    }

    public CompletableFuture<AWSLogsAsyncResponse> checkAWSLogsLambdaAsyncAsync(AWSAccountAndLambdaRequest body) {
        return this.checkAWSLogsLambdaAsyncWithHttpInfoAsync(body).thenApply(response -> (AWSLogsAsyncResponse)response.getData());
    }

    public ApiResponse<AWSLogsAsyncResponse> checkAWSLogsLambdaAsyncWithHttpInfo(AWSAccountAndLambdaRequest body) throws ApiException {
        AWSAccountAndLambdaRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling checkAWSLogsLambdaAsync");
        }
        String localVarPath = "/api/v1/integration/aws/logs/check_async";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "checkAWSLogsLambdaAsync");
        Invocation.Builder builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.checkAWSLogsLambdaAsync", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSLogsAsyncResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSLogsAsyncResponse>> checkAWSLogsLambdaAsyncWithHttpInfoAsync(AWSAccountAndLambdaRequest body) {
        Invocation.Builder builder;
        AWSAccountAndLambdaRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AWSLogsAsyncResponse>> result = new CompletableFuture<ApiResponse<AWSLogsAsyncResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling checkAWSLogsLambdaAsync"));
            return result;
        }
        String localVarPath = "/api/v1/integration/aws/logs/check_async";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "checkAWSLogsLambdaAsync");
        try {
            builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.checkAWSLogsLambdaAsync", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSLogsAsyncResponse>> result = new CompletableFuture<ApiResponse<AWSLogsAsyncResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSLogsAsyncResponse>(){});
    }

    public AWSLogsAsyncResponse checkAWSLogsServicesAsync(AWSLogsServicesRequest body) throws ApiException {
        return this.checkAWSLogsServicesAsyncWithHttpInfo(body).getData();
    }

    public CompletableFuture<AWSLogsAsyncResponse> checkAWSLogsServicesAsyncAsync(AWSLogsServicesRequest body) {
        return this.checkAWSLogsServicesAsyncWithHttpInfoAsync(body).thenApply(response -> (AWSLogsAsyncResponse)response.getData());
    }

    public ApiResponse<AWSLogsAsyncResponse> checkAWSLogsServicesAsyncWithHttpInfo(AWSLogsServicesRequest body) throws ApiException {
        AWSLogsServicesRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling checkAWSLogsServicesAsync");
        }
        String localVarPath = "/api/v1/integration/aws/logs/services_async";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "checkAWSLogsServicesAsync");
        Invocation.Builder builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.checkAWSLogsServicesAsync", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSLogsAsyncResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSLogsAsyncResponse>> checkAWSLogsServicesAsyncWithHttpInfoAsync(AWSLogsServicesRequest body) {
        Invocation.Builder builder;
        AWSLogsServicesRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AWSLogsAsyncResponse>> result = new CompletableFuture<ApiResponse<AWSLogsAsyncResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling checkAWSLogsServicesAsync"));
            return result;
        }
        String localVarPath = "/api/v1/integration/aws/logs/services_async";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "checkAWSLogsServicesAsync");
        try {
            builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.checkAWSLogsServicesAsync", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSLogsAsyncResponse>> result = new CompletableFuture<ApiResponse<AWSLogsAsyncResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSLogsAsyncResponse>(){});
    }

    public Object createAWSLambdaARN(AWSAccountAndLambdaRequest body) throws ApiException {
        return this.createAWSLambdaARNWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> createAWSLambdaARNAsync(AWSAccountAndLambdaRequest body) {
        return this.createAWSLambdaARNWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> createAWSLambdaARNWithHttpInfo(AWSAccountAndLambdaRequest body) throws ApiException {
        AWSAccountAndLambdaRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAWSLambdaARN");
        }
        String localVarPath = "/api/v1/integration/aws/logs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAWSLambdaARN");
        Invocation.Builder builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.createAWSLambdaARN", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> createAWSLambdaARNWithHttpInfoAsync(AWSAccountAndLambdaRequest body) {
        Invocation.Builder builder;
        AWSAccountAndLambdaRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAWSLambdaARN"));
            return result;
        }
        String localVarPath = "/api/v1/integration/aws/logs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAWSLambdaARN");
        try {
            builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.createAWSLambdaARN", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public Object deleteAWSLambdaARN(AWSAccountAndLambdaRequest body) throws ApiException {
        return this.deleteAWSLambdaARNWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> deleteAWSLambdaARNAsync(AWSAccountAndLambdaRequest body) {
        return this.deleteAWSLambdaARNWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> deleteAWSLambdaARNWithHttpInfo(AWSAccountAndLambdaRequest body) throws ApiException {
        AWSAccountAndLambdaRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteAWSLambdaARN");
        }
        String localVarPath = "/api/v1/integration/aws/logs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAWSLambdaARN");
        Invocation.Builder builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.deleteAWSLambdaARN", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> deleteAWSLambdaARNWithHttpInfoAsync(AWSAccountAndLambdaRequest body) {
        Invocation.Builder builder;
        AWSAccountAndLambdaRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteAWSLambdaARN"));
            return result;
        }
        String localVarPath = "/api/v1/integration/aws/logs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAWSLambdaARN");
        try {
            builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.deleteAWSLambdaARN", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public Object enableAWSLogServices(AWSLogsServicesRequest body) throws ApiException {
        return this.enableAWSLogServicesWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> enableAWSLogServicesAsync(AWSLogsServicesRequest body) {
        return this.enableAWSLogServicesWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> enableAWSLogServicesWithHttpInfo(AWSLogsServicesRequest body) throws ApiException {
        AWSLogsServicesRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling enableAWSLogServices");
        }
        String localVarPath = "/api/v1/integration/aws/logs/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "enableAWSLogServices");
        Invocation.Builder builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.enableAWSLogServices", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> enableAWSLogServicesWithHttpInfoAsync(AWSLogsServicesRequest body) {
        Invocation.Builder builder;
        AWSLogsServicesRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling enableAWSLogServices"));
            return result;
        }
        String localVarPath = "/api/v1/integration/aws/logs/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "enableAWSLogServices");
        try {
            builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.enableAWSLogServices", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public List<AWSLogsListResponse> listAWSLogsIntegrations() throws ApiException {
        return this.listAWSLogsIntegrationsWithHttpInfo().getData();
    }

    public CompletableFuture<List<AWSLogsListResponse>> listAWSLogsIntegrationsAsync() {
        return this.listAWSLogsIntegrationsWithHttpInfoAsync().thenApply(response -> (List)response.getData());
    }

    public ApiResponse<List<AWSLogsListResponse>> listAWSLogsIntegrationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/aws/logs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listAWSLogsIntegrations");
        Invocation.Builder builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.listAWSLogsIntegrations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<AWSLogsListResponse>>(){});
    }

    public CompletableFuture<ApiResponse<List<AWSLogsListResponse>>> listAWSLogsIntegrationsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/aws/logs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listAWSLogsIntegrations");
        try {
            builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.listAWSLogsIntegrations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<AWSLogsListResponse>>> result = new CompletableFuture<ApiResponse<List<AWSLogsListResponse>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<AWSLogsListResponse>>(){});
    }

    public List<AWSLogsListServicesResponse> listAWSLogsServices() throws ApiException {
        return this.listAWSLogsServicesWithHttpInfo().getData();
    }

    public CompletableFuture<List<AWSLogsListServicesResponse>> listAWSLogsServicesAsync() {
        return this.listAWSLogsServicesWithHttpInfoAsync().thenApply(response -> (List)response.getData());
    }

    public ApiResponse<List<AWSLogsListServicesResponse>> listAWSLogsServicesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/aws/logs/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listAWSLogsServices");
        Invocation.Builder builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.listAWSLogsServices", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<AWSLogsListServicesResponse>>(){});
    }

    public CompletableFuture<ApiResponse<List<AWSLogsListServicesResponse>>> listAWSLogsServicesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/aws/logs/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listAWSLogsServices");
        try {
            builder = this.apiClient.createBuilder("AwsLogsIntegrationApi.listAWSLogsServices", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<AWSLogsListServicesResponse>>> result = new CompletableFuture<ApiResponse<List<AWSLogsListServicesResponse>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<AWSLogsListServicesResponse>>(){});
    }
}

