/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.User;
import com.datadog.api.v2.client.model.UserResponseIncludedItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response containing information about a single user.")
@JsonPropertyOrder(value={"data", "included"})
public class UserResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private User data;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<UserResponseIncludedItem> included = null;

    public UserResponse data(User data) {
        this.data = data;
        this.unparsed |= data.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getData() {
        return this.data;
    }

    public void setData(User data) {
        this.data = data;
    }

    public UserResponse included(List<UserResponseIncludedItem> included) {
        this.included = included;
        for (UserResponseIncludedItem item : included) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UserResponse addIncludedItem(UserResponseIncludedItem includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<UserResponseIncludedItem>();
        }
        this.included.add(includedItem);
        this.unparsed |= includedItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of objects related to the user.")
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UserResponseIncludedItem> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<UserResponseIncludedItem> included) {
        this.included = included;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserResponse userResponse = (UserResponse)o;
        return Objects.equals(this.data, userResponse.data) && Objects.equals(this.included, userResponse.included);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

