/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.MetricTagConfigurationAttributes;
import com.datadog.api.v2.client.model.MetricTagConfigurationType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object for a single metric tag configuration.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class MetricTagConfiguration {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private MetricTagConfigurationAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MetricTagConfigurationType type = MetricTagConfigurationType.MANAGE_TAGS;

    public MetricTagConfiguration attributes(MetricTagConfigurationAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricTagConfigurationAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(MetricTagConfigurationAttributes attributes) {
        this.attributes = attributes;
    }

    public MetricTagConfiguration id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="test.metric.latency", value="The metric name for this resource.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MetricTagConfiguration type(MetricTagConfigurationType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricTagConfigurationType getType() {
        return this.type;
    }

    public void setType(MetricTagConfigurationType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricTagConfiguration metricTagConfiguration = (MetricTagConfiguration)o;
        return Objects.equals(this.attributes, metricTagConfiguration.attributes) && Objects.equals(this.id, metricTagConfiguration.id) && Objects.equals(this.type, metricTagConfiguration.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricTagConfiguration {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

