/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.PermissionsResponse;
import com.datadog.api.v2.client.model.RelationshipToPermission;
import com.datadog.api.v2.client.model.RelationshipToUser;
import com.datadog.api.v2.client.model.RoleCloneRequest;
import com.datadog.api.v2.client.model.RoleCreateRequest;
import com.datadog.api.v2.client.model.RoleCreateResponse;
import com.datadog.api.v2.client.model.RoleResponse;
import com.datadog.api.v2.client.model.RoleUpdateRequest;
import com.datadog.api.v2.client.model.RoleUpdateResponse;
import com.datadog.api.v2.client.model.RolesResponse;
import com.datadog.api.v2.client.model.RolesSort;
import com.datadog.api.v2.client.model.UsersResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class RolesApi {
    private ApiClient apiClient;

    public RolesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RolesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PermissionsResponse addPermissionToRole(String roleId, RelationshipToPermission body) throws ApiException {
        return this.addPermissionToRoleWithHttpInfo(roleId, body).getData();
    }

    public ApiResponse<PermissionsResponse> addPermissionToRoleWithHttpInfo(String roleId, RelationshipToPermission body) throws ApiException {
        RelationshipToPermission localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addPermissionToRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addPermissionToRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "addPermissionToRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.addPermissionToRole", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsersResponse addUserToRole(String roleId, RelationshipToUser body) throws ApiException {
        return this.addUserToRoleWithHttpInfo(roleId, body).getData();
    }

    public ApiResponse<UsersResponse> addUserToRoleWithHttpInfo(String roleId, RelationshipToUser body) throws ApiException {
        RelationshipToUser localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addUserToRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addUserToRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "addUserToRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.addUserToRole", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public RoleResponse cloneRole(String roleId, RoleCloneRequest body) throws ApiException {
        return this.cloneRoleWithHttpInfo(roleId, body).getData();
    }

    public ApiResponse<RoleResponse> cloneRoleWithHttpInfo(String roleId, RoleCloneRequest body) throws ApiException {
        RoleCloneRequest localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling cloneRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling cloneRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/clone".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "cloneRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<RoleResponse> localVarReturnType = new GenericType<RoleResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.cloneRole", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public RoleCreateResponse createRole(RoleCreateRequest body) throws ApiException {
        return this.createRoleWithHttpInfo(body).getData();
    }

    public ApiResponse<RoleCreateResponse> createRoleWithHttpInfo(RoleCreateRequest body) throws ApiException {
        RoleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRole");
        }
        String localVarPath = "/api/v2/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<RoleCreateResponse> localVarReturnType = new GenericType<RoleCreateResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.createRole", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteRole(String roleId) throws ApiException {
        this.deleteRoleWithHttpInfo(roleId);
    }

    public ApiResponse<Void> deleteRoleWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling deleteRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("RolesApi.deleteRole", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public RoleResponse getRole(String roleId) throws ApiException {
        return this.getRoleWithHttpInfo(roleId).getData();
    }

    public ApiResponse<RoleResponse> getRoleWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling getRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<RoleResponse> localVarReturnType = new GenericType<RoleResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.getRole", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public PermissionsResponse listPermissions() throws ApiException {
        return this.listPermissionsWithHttpInfo().getData();
    }

    public ApiResponse<PermissionsResponse> listPermissionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/permissions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listPermissions");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.listPermissions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public PermissionsResponse listRolePermissions(String roleId) throws ApiException {
        return this.listRolePermissionsWithHttpInfo(roleId).getData();
    }

    public ApiResponse<PermissionsResponse> listRolePermissionsWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listRolePermissions");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listRolePermissions");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.listRolePermissions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsersResponse listRoleUsers(String roleId) throws ApiException {
        return this.listRoleUsersWithHttpInfo(roleId, new ListRoleUsersOptionalParameters()).getData();
    }

    public UsersResponse listRoleUsers(String roleId, ListRoleUsersOptionalParameters parameters) throws ApiException {
        return this.listRoleUsersWithHttpInfo(roleId, parameters).getData();
    }

    public ApiResponse<UsersResponse> listRoleUsersWithHttpInfo(String roleId, ListRoleUsersOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listRoleUsers");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String sort = parameters.sort;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listRoleUsers");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.listRoleUsers", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public RolesResponse listRoles() throws ApiException {
        return this.listRolesWithHttpInfo(new ListRolesOptionalParameters()).getData();
    }

    public RolesResponse listRoles(ListRolesOptionalParameters parameters) throws ApiException {
        return this.listRolesWithHttpInfo(parameters).getData();
    }

    public ApiResponse<RolesResponse> listRolesWithHttpInfo(ListRolesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        RolesSort sort = parameters.sort;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listRoles");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<RolesResponse> localVarReturnType = new GenericType<RolesResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.listRoles", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public PermissionsResponse removePermissionFromRole(String roleId, RelationshipToPermission body) throws ApiException {
        return this.removePermissionFromRoleWithHttpInfo(roleId, body).getData();
    }

    public ApiResponse<PermissionsResponse> removePermissionFromRoleWithHttpInfo(String roleId, RelationshipToPermission body) throws ApiException {
        RelationshipToPermission localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling removePermissionFromRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removePermissionFromRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "removePermissionFromRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.removePermissionFromRole", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsersResponse removeUserFromRole(String roleId, RelationshipToUser body) throws ApiException {
        return this.removeUserFromRoleWithHttpInfo(roleId, body).getData();
    }

    public ApiResponse<UsersResponse> removeUserFromRoleWithHttpInfo(String roleId, RelationshipToUser body) throws ApiException {
        RelationshipToUser localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling removeUserFromRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removeUserFromRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "removeUserFromRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.removeUserFromRole", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public RoleUpdateResponse updateRole(String roleId, RoleUpdateRequest body) throws ApiException {
        return this.updateRoleWithHttpInfo(roleId, body).getData();
    }

    public ApiResponse<RoleUpdateResponse> updateRoleWithHttpInfo(String roleId, RoleUpdateRequest body) throws ApiException {
        RoleUpdateRequest localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling updateRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<RoleUpdateResponse> localVarReturnType = new GenericType<RoleUpdateResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.updateRole", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListRolesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private RolesSort sort;
        private String filter;

        public ListRolesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListRolesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListRolesOptionalParameters sort(RolesSort sort) {
            this.sort = sort;
            return this;
        }

        public ListRolesOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }

    public static class ListRoleUsersOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private String sort;
        private String filter;

        public ListRoleUsersOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListRoleUsersOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListRoleUsersOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }

        public ListRoleUsersOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }
}

