/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The number of SNMP devices for each hour for a given organization.")
@JsonPropertyOrder(value={"hour", "snmp_devices"})
public class UsageSNMPHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_SNMP_DEVICES = "snmp_devices";
    private Long snmpDevices;

    public UsageSNMPHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageSNMPHour snmpDevices(Long snmpDevices) {
        this.snmpDevices = snmpDevices;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of SNMP devices.")
    @JsonProperty(value="snmp_devices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSnmpDevices() {
        return this.snmpDevices;
    }

    public void setSnmpDevices(Long snmpDevices) {
        this.snmpDevices = snmpDevices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageSNMPHour usageSNMPHour = (UsageSNMPHour)o;
        return Objects.equals(this.hour, usageSNMPHour.hour) && Objects.equals(this.snmpDevices, usageSNMPHour.snmpDevices);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.snmpDevices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageSNMPHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    snmpDevices: ").append(this.toIndentedString(this.snmpDevices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

