/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The number of indexed logs for each hour for a given organization broken down by retention period.")
@JsonPropertyOrder(value={"indexed_events_count", "live_indexed_events_count", "rehydrated_indexed_events_count", "retention"})
public class UsageLogsByRetentionHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_INDEXED_EVENTS_COUNT = "indexed_events_count";
    private Long indexedEventsCount;
    public static final String JSON_PROPERTY_LIVE_INDEXED_EVENTS_COUNT = "live_indexed_events_count";
    private Long liveIndexedEventsCount;
    public static final String JSON_PROPERTY_REHYDRATED_INDEXED_EVENTS_COUNT = "rehydrated_indexed_events_count";
    private Long rehydratedIndexedEventsCount;
    public static final String JSON_PROPERTY_RETENTION = "retention";
    private String retention;

    public UsageLogsByRetentionHour indexedEventsCount(Long indexedEventsCount) {
        this.indexedEventsCount = indexedEventsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total logs indexed with this retention period during a given hour.")
    @JsonProperty(value="indexed_events_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedEventsCount() {
        return this.indexedEventsCount;
    }

    public void setIndexedEventsCount(Long indexedEventsCount) {
        this.indexedEventsCount = indexedEventsCount;
    }

    public UsageLogsByRetentionHour liveIndexedEventsCount(Long liveIndexedEventsCount) {
        this.liveIndexedEventsCount = liveIndexedEventsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Live logs indexed with this retention period during a given hour.")
    @JsonProperty(value="live_indexed_events_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLiveIndexedEventsCount() {
        return this.liveIndexedEventsCount;
    }

    public void setLiveIndexedEventsCount(Long liveIndexedEventsCount) {
        this.liveIndexedEventsCount = liveIndexedEventsCount;
    }

    public UsageLogsByRetentionHour rehydratedIndexedEventsCount(Long rehydratedIndexedEventsCount) {
        this.rehydratedIndexedEventsCount = rehydratedIndexedEventsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rehydrated logs indexed with this retention period during a given hour.")
    @JsonProperty(value="rehydrated_indexed_events_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRehydratedIndexedEventsCount() {
        return this.rehydratedIndexedEventsCount;
    }

    public void setRehydratedIndexedEventsCount(Long rehydratedIndexedEventsCount) {
        this.rehydratedIndexedEventsCount = rehydratedIndexedEventsCount;
    }

    public UsageLogsByRetentionHour retention(String retention) {
        this.retention = retention;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The retention period in days or \"custom\" for all custom retention usage.")
    @JsonProperty(value="retention")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRetention() {
        return this.retention;
    }

    public void setRetention(String retention) {
        this.retention = retention;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageLogsByRetentionHour usageLogsByRetentionHour = (UsageLogsByRetentionHour)o;
        return Objects.equals(this.indexedEventsCount, usageLogsByRetentionHour.indexedEventsCount) && Objects.equals(this.liveIndexedEventsCount, usageLogsByRetentionHour.liveIndexedEventsCount) && Objects.equals(this.rehydratedIndexedEventsCount, usageLogsByRetentionHour.rehydratedIndexedEventsCount) && Objects.equals(this.retention, usageLogsByRetentionHour.retention);
    }

    public int hashCode() {
        return Objects.hash(this.indexedEventsCount, this.liveIndexedEventsCount, this.rehydratedIndexedEventsCount, this.retention);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageLogsByRetentionHour {\n");
        sb.append("    indexedEventsCount: ").append(this.toIndentedString(this.indexedEventsCount)).append("\n");
        sb.append("    liveIndexedEventsCount: ").append(this.toIndentedString(this.liveIndexedEventsCount)).append("\n");
        sb.append("    rehydratedIndexedEventsCount: ").append(this.toIndentedString(this.rehydratedIndexedEventsCount)).append("\n");
        sb.append("    retention: ").append(this.toIndentedString(this.retention)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

