/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IoT usage for a given organization for a given hour.")
@JsonPropertyOrder(value={"hour", "iot_device_count"})
public class UsageIoTHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_IOT_DEVICE_COUNT = "iot_device_count";
    private Long iotDeviceCount;

    public UsageIoTHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageIoTHour iotDeviceCount(Long iotDeviceCount) {
        this.iotDeviceCount = iotDeviceCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of IoT devices during a given hour.")
    @JsonProperty(value="iot_device_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIotDeviceCount() {
        return this.iotDeviceCount;
    }

    public void setIotDeviceCount(Long iotDeviceCount) {
        this.iotDeviceCount = iotDeviceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageIoTHour usageIoTHour = (UsageIoTHour)o;
        return Objects.equals(this.hour, usageIoTHour.hour) && Objects.equals(this.iotDeviceCount, usageIoTHour.iotDeviceCount);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.iotDeviceCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageIoTHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    iotDeviceCount: ").append(this.toIndentedString(this.iotDeviceCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

