/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of hosts/containers recorded for each hour for a given organization.")
@JsonPropertyOrder(value={"agent_host_count", "alibaba_host_count", "apm_azure_app_service_host_count", "apm_host_count", "aws_host_count", "azure_host_count", "container_count", "gcp_host_count", "heroku_host_count", "host_count", "hour", "infra_azure_app_service", "opentelemetry_host_count", "vsphere_host_count"})
public class UsageHostHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGENT_HOST_COUNT = "agent_host_count";
    private Long agentHostCount;
    public static final String JSON_PROPERTY_ALIBABA_HOST_COUNT = "alibaba_host_count";
    private Long alibabaHostCount;
    public static final String JSON_PROPERTY_APM_AZURE_APP_SERVICE_HOST_COUNT = "apm_azure_app_service_host_count";
    private Long apmAzureAppServiceHostCount;
    public static final String JSON_PROPERTY_APM_HOST_COUNT = "apm_host_count";
    private Long apmHostCount;
    public static final String JSON_PROPERTY_AWS_HOST_COUNT = "aws_host_count";
    private Long awsHostCount;
    public static final String JSON_PROPERTY_AZURE_HOST_COUNT = "azure_host_count";
    private Long azureHostCount;
    public static final String JSON_PROPERTY_CONTAINER_COUNT = "container_count";
    private Long containerCount;
    public static final String JSON_PROPERTY_GCP_HOST_COUNT = "gcp_host_count";
    private Long gcpHostCount;
    public static final String JSON_PROPERTY_HEROKU_HOST_COUNT = "heroku_host_count";
    private Long herokuHostCount;
    public static final String JSON_PROPERTY_HOST_COUNT = "host_count";
    private Long hostCount;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_INFRA_AZURE_APP_SERVICE = "infra_azure_app_service";
    private Long infraAzureAppService;
    public static final String JSON_PROPERTY_OPENTELEMETRY_HOST_COUNT = "opentelemetry_host_count";
    private Long opentelemetryHostCount;
    public static final String JSON_PROPERTY_VSPHERE_HOST_COUNT = "vsphere_host_count";
    private Long vsphereHostCount;

    public UsageHostHour agentHostCount(Long agentHostCount) {
        this.agentHostCount = agentHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of infrastructure hosts reporting during a given hour that were running the Datadog Agent.")
    @JsonProperty(value="agent_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAgentHostCount() {
        return this.agentHostCount;
    }

    public void setAgentHostCount(Long agentHostCount) {
        this.agentHostCount = agentHostCount;
    }

    public UsageHostHour alibabaHostCount(Long alibabaHostCount) {
        this.alibabaHostCount = alibabaHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of hosts that reported through Alibaba integration (and were NOT running the Datadog Agent).")
    @JsonProperty(value="alibaba_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAlibabaHostCount() {
        return this.alibabaHostCount;
    }

    public void setAlibabaHostCount(Long alibabaHostCount) {
        this.alibabaHostCount = alibabaHostCount;
    }

    public UsageHostHour apmAzureAppServiceHostCount(Long apmAzureAppServiceHostCount) {
        this.apmAzureAppServiceHostCount = apmAzureAppServiceHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of Azure App Services hosts using APM.")
    @JsonProperty(value="apm_azure_app_service_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getApmAzureAppServiceHostCount() {
        return this.apmAzureAppServiceHostCount;
    }

    public void setApmAzureAppServiceHostCount(Long apmAzureAppServiceHostCount) {
        this.apmAzureAppServiceHostCount = apmAzureAppServiceHostCount;
    }

    public UsageHostHour apmHostCount(Long apmHostCount) {
        this.apmHostCount = apmHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the total number of hosts using APM during the hour, these are counted as billable (except during trial periods).")
    @JsonProperty(value="apm_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getApmHostCount() {
        return this.apmHostCount;
    }

    public void setApmHostCount(Long apmHostCount) {
        this.apmHostCount = apmHostCount;
    }

    public UsageHostHour awsHostCount(Long awsHostCount) {
        this.awsHostCount = awsHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of hosts that reported through the AWS integration (and were NOT running the Datadog Agent).")
    @JsonProperty(value="aws_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsHostCount() {
        return this.awsHostCount;
    }

    public void setAwsHostCount(Long awsHostCount) {
        this.awsHostCount = awsHostCount;
    }

    public UsageHostHour azureHostCount(Long azureHostCount) {
        this.azureHostCount = azureHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of hosts that reported through Azure integration (and were NOT running the Datadog Agent).")
    @JsonProperty(value="azure_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAzureHostCount() {
        return this.azureHostCount;
    }

    public void setAzureHostCount(Long azureHostCount) {
        this.azureHostCount = azureHostCount;
    }

    public UsageHostHour containerCount(Long containerCount) {
        this.containerCount = containerCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the total number of containers reported by the Docker integration during the hour.")
    @JsonProperty(value="container_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerCount() {
        return this.containerCount;
    }

    public void setContainerCount(Long containerCount) {
        this.containerCount = containerCount;
    }

    public UsageHostHour gcpHostCount(Long gcpHostCount) {
        this.gcpHostCount = gcpHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of hosts that reported through the Google Cloud integration (and were NOT running the Datadog Agent).")
    @JsonProperty(value="gcp_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getGcpHostCount() {
        return this.gcpHostCount;
    }

    public void setGcpHostCount(Long gcpHostCount) {
        this.gcpHostCount = gcpHostCount;
    }

    public UsageHostHour herokuHostCount(Long herokuHostCount) {
        this.herokuHostCount = herokuHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of Heroku dynos reported by the Datadog Agent.")
    @JsonProperty(value="heroku_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHerokuHostCount() {
        return this.herokuHostCount;
    }

    public void setHerokuHostCount(Long herokuHostCount) {
        this.herokuHostCount = herokuHostCount;
    }

    public UsageHostHour hostCount(Long hostCount) {
        this.hostCount = hostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of billable infrastructure hosts reporting during a given hour. This is the sum of `agent_host_count`, `aws_host_count`, and `gcp_host_count`.")
    @JsonProperty(value="host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHostCount() {
        return this.hostCount;
    }

    public void setHostCount(Long hostCount) {
        this.hostCount = hostCount;
    }

    public UsageHostHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageHostHour infraAzureAppService(Long infraAzureAppService) {
        this.infraAzureAppService = infraAzureAppService;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of hosts that reported through the Azure App Services integration (and were NOT running the Datadog Agent).")
    @JsonProperty(value="infra_azure_app_service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInfraAzureAppService() {
        return this.infraAzureAppService;
    }

    public void setInfraAzureAppService(Long infraAzureAppService) {
        this.infraAzureAppService = infraAzureAppService;
    }

    public UsageHostHour opentelemetryHostCount(Long opentelemetryHostCount) {
        this.opentelemetryHostCount = opentelemetryHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of hosts reported by Datadog exporter for the OpenTelemetry Collector.")
    @JsonProperty(value="opentelemetry_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOpentelemetryHostCount() {
        return this.opentelemetryHostCount;
    }

    public void setOpentelemetryHostCount(Long opentelemetryHostCount) {
        this.opentelemetryHostCount = opentelemetryHostCount;
    }

    public UsageHostHour vsphereHostCount(Long vsphereHostCount) {
        this.vsphereHostCount = vsphereHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of hosts that reported through vSphere integration (and were NOT running the Datadog Agent).")
    @JsonProperty(value="vsphere_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVsphereHostCount() {
        return this.vsphereHostCount;
    }

    public void setVsphereHostCount(Long vsphereHostCount) {
        this.vsphereHostCount = vsphereHostCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageHostHour usageHostHour = (UsageHostHour)o;
        return Objects.equals(this.agentHostCount, usageHostHour.agentHostCount) && Objects.equals(this.alibabaHostCount, usageHostHour.alibabaHostCount) && Objects.equals(this.apmAzureAppServiceHostCount, usageHostHour.apmAzureAppServiceHostCount) && Objects.equals(this.apmHostCount, usageHostHour.apmHostCount) && Objects.equals(this.awsHostCount, usageHostHour.awsHostCount) && Objects.equals(this.azureHostCount, usageHostHour.azureHostCount) && Objects.equals(this.containerCount, usageHostHour.containerCount) && Objects.equals(this.gcpHostCount, usageHostHour.gcpHostCount) && Objects.equals(this.herokuHostCount, usageHostHour.herokuHostCount) && Objects.equals(this.hostCount, usageHostHour.hostCount) && Objects.equals(this.hour, usageHostHour.hour) && Objects.equals(this.infraAzureAppService, usageHostHour.infraAzureAppService) && Objects.equals(this.opentelemetryHostCount, usageHostHour.opentelemetryHostCount) && Objects.equals(this.vsphereHostCount, usageHostHour.vsphereHostCount);
    }

    public int hashCode() {
        return Objects.hash(this.agentHostCount, this.alibabaHostCount, this.apmAzureAppServiceHostCount, this.apmHostCount, this.awsHostCount, this.azureHostCount, this.containerCount, this.gcpHostCount, this.herokuHostCount, this.hostCount, this.hour, this.infraAzureAppService, this.opentelemetryHostCount, this.vsphereHostCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageHostHour {\n");
        sb.append("    agentHostCount: ").append(this.toIndentedString(this.agentHostCount)).append("\n");
        sb.append("    alibabaHostCount: ").append(this.toIndentedString(this.alibabaHostCount)).append("\n");
        sb.append("    apmAzureAppServiceHostCount: ").append(this.toIndentedString(this.apmAzureAppServiceHostCount)).append("\n");
        sb.append("    apmHostCount: ").append(this.toIndentedString(this.apmHostCount)).append("\n");
        sb.append("    awsHostCount: ").append(this.toIndentedString(this.awsHostCount)).append("\n");
        sb.append("    azureHostCount: ").append(this.toIndentedString(this.azureHostCount)).append("\n");
        sb.append("    containerCount: ").append(this.toIndentedString(this.containerCount)).append("\n");
        sb.append("    gcpHostCount: ").append(this.toIndentedString(this.gcpHostCount)).append("\n");
        sb.append("    herokuHostCount: ").append(this.toIndentedString(this.herokuHostCount)).append("\n");
        sb.append("    hostCount: ").append(this.toIndentedString(this.hostCount)).append("\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    infraAzureAppService: ").append(this.toIndentedString(this.infraAzureAppService)).append("\n");
        sb.append("    opentelemetryHostCount: ").append(this.toIndentedString(this.opentelemetryHostCount)).append("\n");
        sb.append("    vsphereHostCount: ").append(this.toIndentedString(this.vsphereHostCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

