/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsPrivateLocation;
import com.datadog.api.v1.client.model.SyntheticsPrivateLocationCreationResponseResultEncryption;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object that contains the new private location, the public key for result encryption, and the configuration skeleton.")
@JsonPropertyOrder(value={"config", "private_location", "result_encryption"})
public class SyntheticsPrivateLocationCreationResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private Object config;
    public static final String JSON_PROPERTY_PRIVATE_LOCATION = "private_location";
    private SyntheticsPrivateLocation privateLocation;
    public static final String JSON_PROPERTY_RESULT_ENCRYPTION = "result_encryption";
    private SyntheticsPrivateLocationCreationResponseResultEncryption resultEncryption;

    public SyntheticsPrivateLocationCreationResponse config(Object config) {
        this.config = config;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Configuration skeleton for the private location. See installation instructions of the private location on how to use this configuration.")
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getConfig() {
        return this.config;
    }

    public void setConfig(Object config) {
        this.config = config;
    }

    public SyntheticsPrivateLocationCreationResponse privateLocation(SyntheticsPrivateLocation privateLocation) {
        this.privateLocation = privateLocation;
        this.unparsed |= privateLocation.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="private_location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsPrivateLocation getPrivateLocation() {
        return this.privateLocation;
    }

    public void setPrivateLocation(SyntheticsPrivateLocation privateLocation) {
        this.privateLocation = privateLocation;
    }

    public SyntheticsPrivateLocationCreationResponse resultEncryption(SyntheticsPrivateLocationCreationResponseResultEncryption resultEncryption) {
        this.resultEncryption = resultEncryption;
        this.unparsed |= resultEncryption.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="result_encryption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsPrivateLocationCreationResponseResultEncryption getResultEncryption() {
        return this.resultEncryption;
    }

    public void setResultEncryption(SyntheticsPrivateLocationCreationResponseResultEncryption resultEncryption) {
        this.resultEncryption = resultEncryption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsPrivateLocationCreationResponse syntheticsPrivateLocationCreationResponse = (SyntheticsPrivateLocationCreationResponse)o;
        return Objects.equals(this.config, syntheticsPrivateLocationCreationResponse.config) && Objects.equals(this.privateLocation, syntheticsPrivateLocationCreationResponse.privateLocation) && Objects.equals(this.resultEncryption, syntheticsPrivateLocationCreationResponse.resultEncryption);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.privateLocation, this.resultEncryption);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsPrivateLocationCreationResponse {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    privateLocation: ").append(this.toIndentedString(this.privateLocation)).append("\n");
        sb.append("    resultEncryption: ").append(this.toIndentedString(this.resultEncryption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

