/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsConfigVariableType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object defining a variable that can be used in your test configuration.")
@JsonPropertyOrder(value={"example", "id", "name", "pattern", "type"})
public class SyntheticsConfigVariable {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EXAMPLE = "example";
    private String example;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PATTERN = "pattern";
    private String pattern;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsConfigVariableType type;

    public SyntheticsConfigVariable() {
    }

    @JsonCreator
    public SyntheticsConfigVariable(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="type") SyntheticsConfigVariableType type) {
        this.name = name;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public SyntheticsConfigVariable example(String example) {
        this.example = example;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Example for the variable.")
    @JsonProperty(value="example")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public SyntheticsConfigVariable id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the variable for global variables.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SyntheticsConfigVariable name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="VARIABLE_NAME", required=true, value="Name of the variable.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsConfigVariable pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pattern of the variable.")
    @JsonProperty(value="pattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public SyntheticsConfigVariable type(SyntheticsConfigVariableType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsConfigVariableType getType() {
        return this.type;
    }

    public void setType(SyntheticsConfigVariableType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsConfigVariable syntheticsConfigVariable = (SyntheticsConfigVariable)o;
        return Objects.equals(this.example, syntheticsConfigVariable.example) && Objects.equals(this.id, syntheticsConfigVariable.id) && Objects.equals(this.name, syntheticsConfigVariable.name) && Objects.equals(this.pattern, syntheticsConfigVariable.pattern) && Objects.equals(this.type, syntheticsConfigVariable.type);
    }

    public int hashCode() {
        return Objects.hash(this.example, this.id, this.name, this.pattern, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsConfigVariable {\n");
        sb.append("    example: ").append(this.toIndentedString(this.example)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

