/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ScatterplotDimension;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Formula to be used in a Scatterplot widget query.")
@JsonPropertyOrder(value={"alias", "dimension", "formula"})
public class ScatterplotWidgetFormula {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias;
    public static final String JSON_PROPERTY_DIMENSION = "dimension";
    private ScatterplotDimension dimension;
    public static final String JSON_PROPERTY_FORMULA = "formula";
    private String formula;

    public ScatterplotWidgetFormula() {
    }

    @JsonCreator
    public ScatterplotWidgetFormula(@JsonProperty(required=true, value="dimension") ScatterplotDimension dimension, @JsonProperty(required=true, value="formula") String formula) {
        this.dimension = dimension;
        this.unparsed |= !dimension.isValid();
        this.formula = formula;
    }

    public ScatterplotWidgetFormula alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="my-query", value="Expression alias.")
    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ScatterplotWidgetFormula dimension(ScatterplotDimension dimension) {
        this.dimension = dimension;
        this.unparsed |= !dimension.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="dimension")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ScatterplotDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(ScatterplotDimension dimension) {
        if (!dimension.isValid()) {
            this.unparsed = true;
        }
        this.dimension = dimension;
    }

    public ScatterplotWidgetFormula formula(String formula) {
        this.formula = formula;
        return this;
    }

    @ApiModelProperty(example="func(a) + b", required=true, value="String expression built from queries, formulas, and functions.")
    @JsonProperty(value="formula")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScatterplotWidgetFormula scatterplotWidgetFormula = (ScatterplotWidgetFormula)o;
        return Objects.equals(this.alias, scatterplotWidgetFormula.alias) && Objects.equals(this.dimension, scatterplotWidgetFormula.dimension) && Objects.equals(this.formula, scatterplotWidgetFormula.formula);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.dimension, this.formula);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScatterplotWidgetFormula {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    dimension: ").append(this.toIndentedString(this.dimension)).append("\n");
        sb.append("    formula: ").append(this.toIndentedString(this.formula)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

