/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An object describing the error with error type and error message.")
@JsonPropertyOrder(value={"error_message", "error_type"})
public class SLOHistoryResponseErrorWithType {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "error_message";
    private String errorMessage;
    public static final String JSON_PROPERTY_ERROR_TYPE = "error_type";
    private String errorType;

    public SLOHistoryResponseErrorWithType() {
    }

    @JsonCreator
    public SLOHistoryResponseErrorWithType(@JsonProperty(required=true, value="error_message") String errorMessage, @JsonProperty(required=true, value="error_type") String errorType) {
        this.errorMessage = errorMessage;
        this.errorType = errorType;
    }

    public SLOHistoryResponseErrorWithType errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="A message with more details about the error.")
    @JsonProperty(value="error_message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public SLOHistoryResponseErrorWithType errorType(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Type of the error.")
    @JsonProperty(value="error_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryResponseErrorWithType slOHistoryResponseErrorWithType = (SLOHistoryResponseErrorWithType)o;
        return Objects.equals(this.errorMessage, slOHistoryResponseErrorWithType.errorMessage) && Objects.equals(this.errorType, slOHistoryResponseErrorWithType.errorType);
    }

    public int hashCode() {
        return Objects.hash(this.errorMessage, this.errorType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryResponseErrorWithType {\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorType: ").append(this.toIndentedString(this.errorType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

